/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.capellacommon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacommon.StateEvent;
import org.polarsys.capella.core.data.capellacommon.StateTransition;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.Operation;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;

public class GetAvailable_StateTransitionTrigger
extends AbstractQuery {
    static Predicate<EObject> predicate_isCandidate = object -> object instanceof ExchangeItem || object instanceof Operation || object instanceof StateEvent;

    public List<Object> execute(Object input, IQueryContext context) {
        List<Object> availableElements = GetAvailable_StateTransitionTrigger.getAvailableElements(input, context);
        return availableElements;
    }

    public static List<Object> getAvailableElements(Object input, IQueryContext context) {
        EObject eContainer;
        CapellaElement inputElement = (CapellaElement)input;
        ArrayList<Object> availableElements = new ArrayList<Object>();
        BlockArchitecture arch = SystemEngineeringExt.getRootBlockArchitecture((ModelElement)inputElement);
        if (arch != null) {
            for (BlockArchitecture block : BlockArchitectureExt.getAllAllocatedArchitectures((BlockArchitecture)arch)) {
                availableElements.addAll(EObjectExt.getAll((EObject)block, predicate_isCandidate));
            }
        }
        if (inputElement instanceof StateTransition && (eContainer = EcoreUtil2.getFirstContainer((EObject)inputElement, (EClass)CsPackage.Literals.COMPONENT)) != null) {
            availableElements.addAll(GetAvailable_StateTransitionTrigger.getElementsFromComponentAndSubComponents((Component)eContainer));
        }
        return availableElements;
    }

    private static List<CapellaElement> getElementsFromComponentAndSubComponents(Component component) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        List subComponents = ComponentExt.getAllSubUsedAndDeployedComponents((Component)component);
        subComponents.add(component);
        for (Component cpnt : subComponents) {
            availableElements.addAll((Collection<CapellaElement>)cpnt.getAllocatedFunctions());
            for (AbstractFunction function : cpnt.getAllocatedFunctions()) {
                availableElements.addAll(FunctionExt.getOutGoingExchange((AbstractFunction)function));
                availableElements.addAll(FunctionExt.getIncomingExchange((AbstractFunction)function));
            }
        }
        return availableElements;
    }
}

