/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.text.FindReplaceDocumentAdapterContentProposalProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.internal.ui.SearchDialog;
import org.eclipse.search.ui.IReplacePage;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.polarsys.capella.core.commands.preferences.util.PreferencesHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.core.ui.search.CapellaReplaceHistory;
import org.polarsys.capella.core.ui.search.CapellaReplaceRunnable;
import org.polarsys.capella.core.ui.search.CapellaReplaceRunnableWrapper;
import org.polarsys.capella.core.ui.search.CapellaSearchQuery;
import org.polarsys.capella.core.ui.search.CapellaSearchSettings;
import org.polarsys.capella.core.ui.search.CapellaSearchSettingsHistory;
import org.polarsys.capella.core.ui.search.match.SearchMatch;
import org.polarsys.capella.core.ui.search.result.CapellaSearchResult;
import org.polarsys.capella.core.ui.search.searchfor.CapellaLeftSearchForContainerArea;
import org.polarsys.capella.core.ui.search.searchfor.CapellaRightSearchForContainerArea;

public class CapellaSearchPage
extends DialogPage
implements ISearchPage,
IReplacePage {
    public static final int WORKSPACE_SCOPE = 0;
    public static final int SELECTED_ELEMENT_SCOPE = 1;
    public static final int PROJECT_SCOPE = 2;
    private int selectedScope;
    private List<CapellaSearchSettings> previousSearchSettings = new ArrayList<CapellaSearchSettings>();
    private Combo comboSearchPattern;
    private Label labelForComboSearchPattern;
    private CLabel labelValidationStatus;
    private ContentAssistCommandAdapter comboSearchPatternRegexContentAssist;
    private Button checkboxCaseSensitive;
    private Button checkboxRegex;
    private Button checkboxWholeWord;
    private Button workspaceBtn;
    private Button selectedElementBtn;
    private Button projectBtn;
    private ISearchPageContainer searchPageContainer;
    private CapellaSearchSettings capellaSearchSettings;
    private CapellaLeftSearchForContainerArea leftCont;
    private CapellaRightSearchForContainerArea rightCont;

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.previousSearchSettings.addAll(CapellaSearchSettingsHistory.getInstance().getAllSearchSettings());
        CompositeForSearchPage composite = new CompositeForSearchPage(parent, 0);
        composite.setFont(parent.getFont());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).applyTo((Composite)composite);
        this.createSearchPatternControls(composite);
        this.createSearchForGroup(composite);
        this.createScopeGroup(composite);
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
    }

    private void createSearchPatternControls(Composite group) {
        this.createLabelForComboSearchPattern(group);
        Composite column1 = new Composite(group, 0);
        column1.setFont(group.getFont());
        GridLayoutFactory.fillDefaults().applyTo(column1);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)column1);
        this.createComboSearchPattern(column1);
        this.createLabelValidationStatus(column1);
        Composite column2 = new Composite(group, 0);
        column2.setFont(group.getFont());
        GridLayoutFactory.fillDefaults().applyTo(column2);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)column2);
        this.createCheckboxCaseSensitive(column2);
        this.createCheckboxRegex(column2);
        this.createCheckboxWholeWord(column2);
    }

    private void createLabelForComboSearchPattern(Composite group) {
        this.labelForComboSearchPattern = new Label(group, 16384);
        this.labelForComboSearchPattern.setText("Containing text (* = any string, ? = any character, \\ = escape for literals: * ? \\):");
        GridDataFactory.swtDefaults().align(4, 0x1000000).span(2, 1).grab(false, false).applyTo((Control)this.labelForComboSearchPattern);
        this.labelForComboSearchPattern.setFont(group.getFont());
    }

    private void createComboSearchPattern(Composite group) {
        this.comboSearchPattern = new Combo(group, 2052);
        this.comboSearchPattern.setFont(group.getFont());
        GridDataFactory.fillDefaults().grab(true, false).hint(this.convertWidthInCharsToPixels(50), -1).applyTo((Control)this.comboSearchPattern);
        this.comboSearchPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CapellaSearchSettings previous;
                int selectionIndex = CapellaSearchPage.this.comboSearchPattern.getSelectionIndex();
                if (-1 < selectionIndex && selectionIndex < CapellaSearchPage.this.previousSearchSettings.size() && (previous = CapellaSearchPage.this.previousSearchSettings.get(selectionIndex)) != null) {
                    CapellaSearchPage.this.applySearchSettings(previous);
                }
            }
        });
        this.comboSearchPattern.setToolTipText("Containing text (Regular expression):");
        ComboContentAdapter contentAdapter = new ComboContentAdapter();
        FindReplaceDocumentAdapterContentProposalProvider findProposer = new FindReplaceDocumentAdapterContentProposalProvider(true);
        this.comboSearchPatternRegexContentAssist = new ContentAssistCommandAdapter((Control)this.comboSearchPattern, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)findProposer, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[0], true);
        this.comboSearchPatternRegexContentAssist.setEnabled(false);
    }

    private void createLabelValidationStatus(Composite group) {
        this.labelValidationStatus = new CLabel(group, 16384);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)this.labelValidationStatus);
        this.labelValidationStatus.setFont(group.getFont());
        this.labelValidationStatus.setAlignment(16384);
        this.labelValidationStatus.setForeground(JFaceColors.getErrorText((Display)this.labelValidationStatus.getDisplay()));
    }

    private void createCheckboxCaseSensitive(Composite group) {
        this.checkboxCaseSensitive = new Button(group, 32);
        this.checkboxCaseSensitive.setText("Case sensitive");
        GridDataFactory.fillDefaults().applyTo((Control)this.checkboxCaseSensitive);
        this.checkboxCaseSensitive.setFont(group.getFont());
    }

    private void createCheckboxRegex(Composite group) {
        this.checkboxRegex = new Button(group, 32);
        this.checkboxRegex.setText("Regular expression");
        GridDataFactory.fillDefaults().applyTo((Control)this.checkboxRegex);
        this.checkboxRegex.setFont(group.getFont());
        this.checkboxRegex.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean regexEnabled = CapellaSearchPage.this.checkboxRegex.getSelection();
                CapellaSearchPage.this.comboSearchPatternRegexContentAssist.setEnabled(regexEnabled);
                if (regexEnabled) {
                    CapellaSearchPage.this.labelForComboSearchPattern.setText("Containing text (Regular expression):");
                    CapellaSearchPage.this.checkboxWholeWord.setEnabled(false);
                } else {
                    CapellaSearchPage.this.labelForComboSearchPattern.setText("Containing text (* = any string, ? = any character, \\ = escape for literals: * ? \\):");
                    CapellaSearchPage.this.checkboxWholeWord.setEnabled(true);
                }
            }
        });
    }

    private void createCheckboxWholeWord(Composite group) {
        this.checkboxWholeWord = new Button(group, 32);
        this.checkboxWholeWord.setText("Whole word");
        GridDataFactory.fillDefaults().applyTo((Control)this.checkboxWholeWord);
        this.checkboxWholeWord.setFont(group.getFont());
    }

    private void createSearchForGroup(Composite parent) {
        Group qGrp = new Group(parent, 0);
        qGrp.setLayout((Layout)new GridLayout(4, false));
        GridData gdGrp = new GridData(1808);
        gdGrp.horizontalSpan = 2;
        gdGrp.heightHint = 250;
        qGrp.setLayoutData((Object)gdGrp);
        qGrp.setText("Search for (* = any string, ? = any character, \\ = escape for literals: * ? \\):");
        this.leftCont = new CapellaLeftSearchForContainerArea(qGrp, this);
        this.rightCont = new CapellaRightSearchForContainerArea(qGrp, this.leftCont, this);
        this.leftCont.setOtherSideArea(this.rightCont);
        this.leftCont.createFiltercontainer(qGrp);
    }

    private void createScopeGroup(Composite parent) {
        Group scopeGroup = new Group(parent, 0);
        scopeGroup.setLayout((Layout)new GridLayout(4, false));
        GridDataFactory.swtDefaults().align(4, 0x1000000).span(2, 1).grab(false, false).applyTo((Control)scopeGroup);
        scopeGroup.setText("Scope");
        this.workspaceBtn = new Button((Composite)scopeGroup, 16);
        this.workspaceBtn.setData((Object)0);
        this.workspaceBtn.setText("Workspace");
        this.selectedElementBtn = new Button((Composite)scopeGroup, 16);
        this.selectedElementBtn.setData((Object)1);
        this.selectedElementBtn.setText("Selected model elements");
        this.projectBtn = new Button((Composite)scopeGroup, 16);
        this.projectBtn.setData((Object)2);
        this.projectBtn.setText("Enclosing projects");
        SelectionAdapter scopeChangedLister = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CapellaSearchPage.this.handleScopeChanged(e);
            }
        };
        this.workspaceBtn.addSelectionListener((SelectionListener)scopeChangedLister);
        this.selectedElementBtn.addSelectionListener((SelectionListener)scopeChangedLister);
        this.projectBtn.addSelectionListener((SelectionListener)scopeChangedLister);
        this.setScopeAndUpdateUI(0);
    }

    private void handleScopeChanged(SelectionEvent e) {
        Button button;
        Object source = e.getSource();
        if (source instanceof Button && (button = (Button)source).getSelection()) {
            this.selectedScope = (Integer)button.getData();
        }
    }

    public void setScopeAndUpdateUI(int scope) {
        this.selectedScope = scope;
        this.workspaceBtn.setSelection(scope == 0);
        this.selectedElementBtn.setSelection(scope == 1);
        this.projectBtn.setSelection(scope == 2);
    }

    protected void applySearchSettings(CapellaSearchSettings settings) {
        this.capellaSearchSettings = settings;
        this.checkboxCaseSensitive.setSelection(settings.isCaseSensitive());
        this.comboSearchPattern.setText(settings.getTextPattern());
        this.checkboxWholeWord.setSelection(settings.isWholeWord());
        boolean regexEnabled = settings.isRegExSearch();
        this.checkboxRegex.setSelection(regexEnabled);
        this.comboSearchPatternRegexContentAssist.setEnabled(regexEnabled);
        if (regexEnabled) {
            this.labelForComboSearchPattern.setText("Containing text (Regular expression):");
        } else {
            this.labelForComboSearchPattern.setText("Containing text (* = any string, ? = any character, \\ = escape for literals: * ? \\):");
        }
        if (this.leftCont != null) {
            this.leftCont.applySearchSettings(settings);
        }
        if (this.rightCont != null) {
            this.rightCont.applySearchSettings(settings);
        }
        int scope = settings.getScope();
        this.setScopeAndUpdateUI(scope);
        this.validate();
    }

    protected void applyDefaultSearchSettings() {
        this.checkboxCaseSensitive.setSelection(false);
        this.comboSearchPattern.setText("");
        this.checkboxWholeWord.setSelection(false);
        this.checkboxRegex.setSelection(false);
        if (this.leftCont != null) {
            this.leftCont.applyDefaultSearchSettings();
        }
        if (this.rightCont != null) {
            this.rightCont.applyDefaultSearchSettings();
        }
        this.setScopeAndUpdateUI(0);
    }

    public CapellaSearchSettings getCapellaSearchSettings() {
        if (this.capellaSearchSettings == null) {
            this.capellaSearchSettings = new CapellaSearchSettings();
        }
        return this.capellaSearchSettings;
    }

    public void setVisible(boolean visible) {
        if (visible && this.comboSearchPattern != null) {
            if (!this.previousSearchSettings.isEmpty()) {
                String[] previousSearchPatterns = (String[])this.previousSearchSettings.stream().map(CapellaSearchSettings::getTextPattern).toArray(String[]::new);
                this.comboSearchPattern.setItems(previousSearchPatterns);
                this.comboSearchPattern.select(0);
                this.applySearchSettings(this.previousSearchSettings.get(0));
            } else {
                this.applyDefaultSearchSettings();
            }
            this.comboSearchPattern.setFocus();
        }
        super.setVisible(visible);
    }

    private IStatus validate() {
        this.capellaSearchSettings = this.getCapellaSearchSettings();
        this.capellaSearchSettings.setTextPattern(this.comboSearchPattern.getText());
        this.capellaSearchSettings.setCaseSensitive(this.checkboxCaseSensitive.getSelection());
        this.capellaSearchSettings.setRegExSearch(this.checkboxRegex.getSelection());
        this.capellaSearchSettings.setWholeWord(this.checkboxWholeWord.getSelection());
        this.capellaSearchSettings.setScope(this.selectedScope);
        this.capellaSearchSettings.setAbstractChecked(this.leftCont.isAbstractChecked());
        this.capellaSearchSettings.setNonSemanticChecked(this.leftCont.isNonSemanticChecked());
        this.capellaSearchSettings.clearProjects();
        if (this.selectedScope == 0) {
            IProject[] iProjectArray = this.getProjectsFromWorkspace();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project2 = iProjectArray[n2];
                this.capellaSearchSettings.addObjectToSearch(project2);
                ++n2;
            }
        } else if (this.selectedScope == 2) {
            HashSet<IProject> selectedProjects = new HashSet<IProject>();
            ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
            if (selection instanceof IStructuredSelection) {
                for (Object sel : (IStructuredSelection)selection) {
                    if (!(sel instanceof EObject)) continue;
                    selectedProjects.add(PreferencesHelper.getProject((EObject)((EObject)sel)));
                }
            }
            String[] evaluatedProjects = SearchDialog.evaluateEnclosingProject((ISelection)selection, (IEditorPart)this.getActiveEditor());
            IProject[] iProjectArray = this.getProjectsFromWorkspace();
            int n = iProjectArray.length;
            int n3 = 0;
            while (n3 < n) {
                IProject project3 = iProjectArray[n3];
                if (Arrays.asList(evaluatedProjects).contains(project3.getName())) {
                    selectedProjects.add(project3);
                }
                ++n3;
            }
            selectedProjects.stream().forEach(project -> this.capellaSearchSettings.addObjectToSearch(project));
        } else if (this.selectedScope == 1) {
            HashSet<EObject> selectedElements = new HashSet<EObject>();
            ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
            if (selection instanceof IStructuredSelection) {
                for (Object sel : (IStructuredSelection)selection) {
                    EObject semanticObj = CapellaAdapterHelper.resolveSemanticObject(sel);
                    selectedElements.add(semanticObj);
                }
            }
            selectedElements.stream().forEach(project -> this.capellaSearchSettings.addObjectToSearch(project));
        }
        IStatus validateStatus = this.capellaSearchSettings.validate();
        this.updateValidationStatus(validateStatus);
        return validateStatus;
    }

    private IEditorPart getActiveEditor() {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage == null) {
            return null;
        }
        IWorkbenchPart activePart = activePage.getActivePart();
        if (activePart == null) {
            return null;
        }
        IEditorPart activeEditor = activePage.getActiveEditor();
        if (activeEditor == activePart) {
            return activeEditor;
        }
        return null;
    }

    public void updateValidationStatus(IStatus validateStatus) {
        if (validateStatus.isOK()) {
            this.searchPageContainer.setPerformActionEnabled(true);
            this.labelValidationStatus.setText("");
        } else {
            this.labelValidationStatus.setText(validateStatus.getMessage());
            this.searchPageContainer.setPerformActionEnabled(true);
        }
    }

    public boolean performReplace() {
        IStatus validateStatus = this.validate();
        if (validateStatus.isOK()) {
            CapellaSearchQuery searchQuery = new CapellaSearchQuery(this.getCapellaSearchSettings());
            IStatus searchStatus = NewSearchUI.runQueryInForeground((IRunnableContext)this.searchPageContainer.getRunnableContext(), (ISearchQuery)searchQuery);
            if (searchStatus.isOK()) {
                CapellaSearchResult searchResult = searchQuery.getSearchResult();
                if (searchResult.getMatchCount() > 0) {
                    Set<SearchMatch> allMatches = searchResult.getDisplayedMatches();
                    CapellaReplaceRunnable capellaReplaceRunnable = new CapellaReplaceRunnable(searchQuery, allMatches, true);
                    new CapellaReplaceRunnableWrapper(capellaReplaceRunnable).run();
                    if (this.capellaSearchSettings.getReplaceTextPattern() != null) {
                        CapellaSearchSettingsHistory.getInstance().appendSearchSettings(this.capellaSearchSettings);
                        CapellaReplaceHistory.getInstance().appendSearchSettings(this.capellaSearchSettings);
                    }
                } else {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)"Capella Replace", (String)String.format("No match found", searchQuery.getCapellaSearchSettings().getTextPattern()));
                }
            }
            return true;
        }
        return false;
    }

    public boolean performAction() {
        IStatus validateStatus = this.validate();
        if (validateStatus.isOK()) {
            CapellaSearchQuery searchQuery = new CapellaSearchQuery(this.getCapellaSearchSettings());
            NewSearchUI.runQueryInBackground((ISearchQuery)searchQuery);
            CapellaSearchSettingsHistory.getInstance().appendSearchSettings(this.capellaSearchSettings);
            return true;
        }
        return false;
    }

    private IProject[] getProjectsFromWorkspace() {
        IProject[] projectsToCheck = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        return projectsToCheck;
    }

    public void setContainer(ISearchPageContainer container) {
        this.searchPageContainer = container;
    }

    private class CompositeForSearchPage
    extends Composite {
        public CompositeForSearchPage(Composite parent, int style) {
            super(parent, style);
        }

        public void setLayoutData(Object layoutData) {
            if (this.getLayoutData() == null) {
                super.setLayoutData(layoutData);
            }
        }
    }
}

