/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.search.searchfor;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.IProgressService;
import org.polarsys.capella.core.ui.search.CapellaSearchPage;
import org.polarsys.capella.core.ui.search.CapellaSearchSettings;
import org.polarsys.capella.core.ui.search.searchfor.AbstractSearchForContentProvider;
import org.polarsys.capella.core.ui.search.searchfor.CheckboxFilteredTree;
import org.polarsys.capella.core.ui.search.searchfor.SearchForLabelProvider;

public abstract class AbstractCapellaSearchForContainerArea {
    protected Button selectAllButton;
    protected Button deselectAllButton;
    protected Button defaultButton;
    protected Button restoreDefaultsButton;
    protected PatternFilter patternFilter;
    protected CheckboxFilteredTree filteredTree;
    protected Group parentGroup;
    protected int participantsCheckStrategy = 2;
    protected AbstractCapellaSearchForContainerArea otherSideArea;
    protected CapellaSearchPage searchPage;
    protected Set<Object> checkedElements = new HashSet<Object>();

    public AbstractCapellaSearchForContainerArea(Group parent, AbstractCapellaSearchForContainerArea area, CapellaSearchPage page) {
        this.parentGroup = parent;
        this.otherSideArea = area;
        this.searchPage = page;
        this.createContent();
    }

    protected void createContent() {
        this.createContentArea();
        this.createButtonsArea();
    }

    protected void createContentArea() {
        AbstractSearchForContentProvider partictipantsItemProvider = this.getSearchForContentProvider();
        this.patternFilter = this.createPatternFilter();
        this.filteredTree = new CheckboxFilteredTree((Composite)this.parentGroup, 2048, this.patternFilter, this.checkedElements);
        this.filteredTree.getViewer().setContentProvider((IContentProvider)partictipantsItemProvider);
        this.filteredTree.getViewer().setLabelProvider((IBaseLabelProvider)new SearchForLabelProvider());
        this.filteredTree.getViewer().setInput((Object)"");
        this.filteredTree.getViewer().expandAll();
        this.filteredTree.getViewer().getTree().setLayout((Layout)new GridLayout());
        GridData chechboxTreeViewerGridData = new GridData(1808);
        chechboxTreeViewerGridData.heightHint = 140;
        chechboxTreeViewerGridData.widthHint = 250;
        this.filteredTree.getViewer().getTree().setLayoutData((Object)chechboxTreeViewerGridData);
        ((CheckboxTreeViewer)this.filteredTree.getViewer()).addCheckStateListener(this.getCheckStateListener());
    }

    protected ICheckStateListener getCheckStateListener() {
        return event -> {
            boolean state = event.getChecked();
            Object parent = event.getElement();
            this.setCheckedState(parent, state);
            this.updateSearchSettings();
            this.refreshOtherSideArea();
        };
    }

    protected void setCheckedState(Object parent, boolean state) {
        boolean hasChildren = this.getSearchForContentProvider().hasChildren(parent);
        CheckboxTreeViewer viewer = (CheckboxTreeViewer)this.filteredTree.getViewer();
        viewer.setChecked(parent, state);
        this.updateCheckedElements(parent, state);
        if (hasChildren) {
            Object[] objectArray = this.getSearchForContentProvider().getChildren(parent);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                viewer.setChecked(child, state);
                this.updateCheckedElements(child, state);
                ++n2;
            }
        }
    }

    protected void updateCheckedElements(Object obj, boolean state) {
        if (state) {
            this.checkedElements.add(obj);
        } else {
            this.checkedElements.remove(obj);
        }
    }

    protected void cleanCheckedElements() {
        this.checkedElements.clear();
    }

    protected void createButtonsArea() {
        Composite buttonsContainer = new Composite((Composite)this.parentGroup, 0);
        buttonsContainer.setLayout((Layout)new GridLayout());
        GridData rightPaneContainerGridData = new GridData(132);
        rightPaneContainerGridData.heightHint = 140;
        buttonsContainer.setLayoutData((Object)rightPaneContainerGridData);
        this.createSelectAllButton(buttonsContainer);
        this.createDeselectAllButton(buttonsContainer);
        this.createRestoreDefaultsButton(buttonsContainer);
    }

    protected void createSelectAllButton(Composite rightPaneContainer) {
        this.selectAllButton = new Button(rightPaneContainer, 8);
        this.selectAllButton.setLayoutData((Object)new GridData(768));
        this.selectAllButton.setText("Select All");
        this.selectAllButton.addSelectionListener(this.getSelectionListener(true));
        this.selectAllButton.setEnabled(2 == this.participantsCheckStrategy);
    }

    protected void createDeselectAllButton(Composite rightPaneContainer) {
        this.deselectAllButton = new Button(rightPaneContainer, 8);
        this.deselectAllButton.setLayoutData((Object)new GridData(768));
        this.deselectAllButton.setText("Deselect All");
        this.deselectAllButton.addSelectionListener(this.getSelectionListener(false));
        this.deselectAllButton.setEnabled(2 == this.participantsCheckStrategy);
    }

    protected void createRestoreDefaultsButton(Composite rightPaneContainer) {
        this.restoreDefaultsButton = new Button(rightPaneContainer, 8);
        this.restoreDefaultsButton.setLayoutData((Object)new GridData(768));
        this.restoreDefaultsButton.setText("Restore Defaults");
        this.restoreDefaultsButton.addSelectionListener(this.getRestoreDefaultsSelectionListener());
    }

    protected SelectionListener getSelectionListener(final boolean selected) {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IProgressService progressService = workbench.getProgressService();
                try {
                    progressService.runInUI((IRunnableContext)progressService, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            CheckboxTreeViewer checkboxTreeViewer = (CheckboxTreeViewer)(this).AbstractCapellaSearchForContainerArea.this.filteredTree.getViewer();
                            AbstractCapellaSearchForContainerArea.this.checkAll(checkboxTreeViewer, selected);
                            AbstractCapellaSearchForContainerArea.this.updateSearchSettings();
                            AbstractCapellaSearchForContainerArea.this.refreshOtherSideArea();
                        }
                    }, null);
                }
                catch (InterruptedException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
    }

    protected abstract PatternFilter createPatternFilter();

    protected abstract SelectionListener getRestoreDefaultsSelectionListener();

    public void checkAll(CheckboxTreeViewer viewer, boolean state) {
        Object[] viewerElements;
        Object[] objectArray = viewerElements = this.getSearchForContentProvider().getElements("");
        int n = viewerElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            this.setCheckedState(obj, state);
            ++n2;
        }
    }

    protected abstract AbstractSearchForContentProvider getSearchForContentProvider();

    public void setOtherSideArea(AbstractCapellaSearchForContainerArea area) {
        this.otherSideArea = area;
    }

    public void refreshOtherSideArea() {
    }

    public void applySearchSettings(Set<Object> objects) {
        CheckboxTreeViewer checkboxTreeViewer = (CheckboxTreeViewer)this.filteredTree.getViewer();
        this.checkAll(checkboxTreeViewer, false);
        for (Object obj : objects) {
            checkboxTreeViewer.setChecked(obj, true);
            this.updateCheckedElements(obj, true);
        }
        this.refreshOtherSideArea();
    }

    public abstract void applySearchSettings(CapellaSearchSettings var1);

    public abstract void updateSearchSettings();

    public abstract void applyDefaultSearchSettings();

    public void refresh() {
        this.filteredTree.getViewer().refresh();
    }

    public Set<Object> getCheckedElements() {
        return this.checkedElements;
    }
}

