/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.search.searchfor;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.IProgressService;
import org.polarsys.capella.common.ui.toolkit.widgets.filter.CapellaPatternFilter;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.ui.search.CapellaSearchPage;
import org.polarsys.capella.core.ui.search.CapellaSearchSettings;
import org.polarsys.capella.core.ui.search.searchfor.AbstractCapellaSearchForContainerArea;
import org.polarsys.capella.core.ui.search.searchfor.AbstractSearchForContentProvider;
import org.polarsys.capella.core.ui.search.searchfor.ClassContentProvider;
import org.polarsys.capella.core.ui.search.searchfor.SearchForItemCache;
import org.polarsys.capella.core.ui.search.searchfor.item.SearchForClassItem;
import org.polarsys.capella.core.ui.search.searchfor.item.SearchForItem;

public class CapellaLeftSearchForContainerArea
extends AbstractCapellaSearchForContainerArea {
    protected AbstractSearchForContentProvider searchForContentProvider;
    Button checkboxFilterAbstract;
    Button checkboxFilterNonSemantic;

    public CapellaLeftSearchForContainerArea(Group parent, CapellaSearchPage searchPage) {
        super(parent, null, searchPage);
    }

    @Override
    protected ClassContentProvider getSearchForContentProvider() {
        if (this.searchForContentProvider == null) {
            this.searchForContentProvider = new ClassContentProvider();
        }
        return (ClassContentProvider)this.searchForContentProvider;
    }

    @Override
    protected PatternFilter createPatternFilter() {
        return new CapellaPatternFilter();
    }

    @Override
    public void applySearchSettings(CapellaSearchSettings settings) {
        HashSet<Object> searchClassItems = new HashSet<Object>(settings.getSearchClassItems());
        this.applyFilterSearchSettings(settings);
        super.applySearchSettings(searchClassItems);
    }

    private void applyFilterSearchSettings(CapellaSearchSettings settings) {
        boolean settingsNonSemanticChecked;
        boolean updateRequired = false;
        ClassContentProvider classContentProvider = this.getSearchForContentProvider();
        boolean settingsAbstractChecked = settings.isAbstractChecked();
        if (settingsAbstractChecked != classContentProvider.isFilterAbstract()) {
            this.checkboxFilterAbstract.setSelection(settingsAbstractChecked);
            classContentProvider.setFilterAbstract(settingsAbstractChecked);
            updateRequired = true;
        }
        if ((settingsNonSemanticChecked = settings.isNonSemanticChecked()) != classContentProvider.isFilterNonSemantic()) {
            this.checkboxFilterNonSemantic.setSelection(settingsNonSemanticChecked);
            classContentProvider.setFilterNonSemantic(settingsNonSemanticChecked);
            updateRequired = true;
        }
        if (updateRequired) {
            this.applyFilter();
        }
    }

    public boolean isAbstractChecked() {
        return this.checkboxFilterAbstract.getSelection();
    }

    public boolean isNonSemanticChecked() {
        return this.checkboxFilterNonSemantic.getSelection();
    }

    @Override
    public void updateSearchSettings() {
        this.searchPage.getCapellaSearchSettings().setSearchClassItems(this.getCheckedElements());
    }

    public void createFiltercontainer(Group parentGroup) {
        Group searchForSelectionGroup = new Group((Composite)parentGroup, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)searchForSelectionGroup);
        GridDataFactory.swtDefaults().align(4, 0x1000000).span(2, 1).grab(false, false).applyTo((Control)searchForSelectionGroup);
        searchForSelectionGroup.setText("Active filters (matching items will be hidden)");
        this.checkboxFilterAbstract = this.createCheckboxFilters((Composite)searchForSelectionGroup, "Abstract elements", true);
        this.checkboxFilterNonSemantic = this.createCheckboxFilters((Composite)searchForSelectionGroup, "Non Semantic elements", true);
    }

    private Button createCheckboxFilters(Composite group, String label, boolean selected) {
        Button checkboxFilters = new Button(group, 32);
        checkboxFilters.setText(label);
        GridDataFactory.fillDefaults().applyTo((Control)checkboxFilters);
        checkboxFilters.setFont(group.getFont());
        checkboxFilters.setSelection(selected);
        checkboxFilters.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CapellaLeftSearchForContainerArea.this.applyFilter();
            }
        });
        return checkboxFilters;
    }

    protected void applyFilter() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                CheckboxTreeViewer checkboxTreeViewer = (CheckboxTreeViewer)CapellaLeftSearchForContainerArea.this.filteredTree.getViewer();
                ClassContentProvider provider = CapellaLeftSearchForContainerArea.this.getSearchForContentProvider();
                provider.setFilterAbstract(CapellaLeftSearchForContainerArea.this.isAbstractChecked());
                provider.setFilterNonSemantic(CapellaLeftSearchForContainerArea.this.isNonSemanticChecked());
                checkboxTreeViewer.refresh();
                checkboxTreeViewer.expandAll();
            }
        };
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            service.run(false, false, runnable);
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void refreshOtherSideArea() {
        if (this.otherSideArea != null) {
            this.otherSideArea.filteredTree.getViewer().refresh();
        }
    }

    @Override
    protected void createContentArea() {
        super.createContentArea();
        this.filteredTree.getViewer().collapseAll();
        final HashMap<String, Integer> fixedCategories = new HashMap<String, Integer>();
        fixedCategories.put("Model Elements", 0);
        fixedCategories.put("Diagram Elements", 1);
        this.filteredTree.getViewer().setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof SearchForItem && e2 instanceof SearchForItem) {
                    return ((SearchForItem)e1).getText().compareTo(((SearchForItem)e2).getText());
                }
                if (e1 instanceof String && e2 instanceof String) {
                    String category1 = (String)e1;
                    String category2 = (String)e2;
                    Integer indexOfCategory1 = (Integer)fixedCategories.get(category1);
                    Integer indexOfCategory2 = (Integer)fixedCategories.get(category2);
                    if (indexOfCategory1 != null && indexOfCategory2 != null) {
                        return indexOfCategory1 < indexOfCategory2 ? -1 : 1;
                    }
                    if (indexOfCategory1 != null) {
                        return -1;
                    }
                    if (indexOfCategory2 != null) {
                        return 1;
                    }
                    return category1.compareTo(category2);
                }
                return 0;
            }
        });
    }

    @Override
    protected SelectionListener getRestoreDefaultsSelectionListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CapellaLeftSearchForContainerArea.this.applyDefaultSearchSettings();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
    }

    @Override
    public void applyDefaultSearchSettings() {
        Set namedElementClasses = SearchForItemCache.getInstance().getClassItems().stream().filter(SearchForClassItem.class::isInstance).map(SearchForClassItem.class::cast).filter(item -> CapellacorePackage.Literals.NAMED_ELEMENT.isSuperTypeOf((EClass)item.getObject())).collect(Collectors.toSet());
        this.filteredTree.getCheckboxTreeViewer().setCheckedElements(namedElementClasses.toArray());
        this.cleanCheckedElements();
        Object[] objectArray = this.filteredTree.getCheckboxTreeViewer().getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            this.updateCheckedElements(obj, true);
            ++n2;
        }
        this.updateSearchSettings();
        this.refreshOtherSideArea();
    }
}

