/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.search.searchfor;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.polarsys.capella.core.model.semantic.SimplifiedCapellaMetadata;
import org.polarsys.capella.core.ui.search.searchfor.AbstractSearchForContentProvider;
import org.polarsys.capella.core.ui.search.searchfor.SearchForItemCache;
import org.polarsys.capella.core.ui.search.searchfor.item.SearchForClassItem;
import org.polarsys.capella.core.ui.search.searchfor.item.SearchForItem;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;

public class ClassContentProvider
extends AbstractSearchForContentProvider {
    private boolean filterAbstract = true;
    private boolean filterNonSemantic = true;
    protected Map<String, Set<SearchForItem>> elements = new HashMap<String, Set<SearchForItem>>();

    public ClassContentProvider() {
        this.elements.put("Model Elements", SearchForItemCache.getInstance().getCapellaClassItems());
        this.elements.put("Diagram Elements", SearchForItemCache.getInstance().getDiagramItems());
        for (Viewpoint vp : SearchForItemCache.getInstance().getViewpoints()) {
            this.elements.put(vp.getName(), SearchForItemCache.getInstance().getAddonItems(vp));
        }
    }

    @Override
    public Object[] getElements(Object inputElement) {
        if (inputElement != null) {
            return this.elements.keySet().stream().filter(this::hasChildren).toArray();
        }
        return new Object[0];
    }

    @Override
    public Object[] getElements() {
        return new Object[0];
    }

    @Override
    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof String && this.elements.keySet().contains(parentElement)) {
            return this.elements.get(parentElement).stream().filter(this::isDisplayed).collect(Collectors.toSet()).toArray();
        }
        return super.getChildren(parentElement);
    }

    @Override
    public Object getParent(Object element) {
        if (element instanceof EClass) {
            if (this.elements.get("Model Elements").contains(element)) {
                return "Model Elements";
            }
            if (this.elements.get("Diagram Elements").contains(element)) {
                return "Diagram Elements";
            }
        }
        return null;
    }

    public void setFilterAbstract(boolean filterAbstract) {
        this.filterAbstract = filterAbstract;
    }

    public void setFilterNonSemantic(boolean filterNonSemantic) {
        this.filterNonSemantic = filterNonSemantic;
    }

    public boolean isFilterNonSemantic() {
        return this.filterNonSemantic;
    }

    public boolean isFilterAbstract() {
        return this.filterAbstract;
    }

    protected boolean isDisplayed(SearchForItem item) {
        Object obj;
        if (item instanceof SearchForClassItem && (obj = ((SearchForClassItem)item).getObject()) instanceof EClass) {
            EClass eclass = (EClass)obj;
            if (this.filterAbstract && eclass.isAbstract()) {
                return false;
            }
            return !this.filterNonSemantic || SimplifiedCapellaMetadata.INSTANCE.isSemantic((EClassifier)eclass);
        }
        return false;
    }
}

