/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.validation.function;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.AbstractFunctionalBlock;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.RefinementLinkExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class CFA01_ComponentFunctionAllocation
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof ComponentFunctionalAllocation) {
            ComponentFunctionalAllocation fci = (ComponentFunctionalAllocation)eObj;
            boolean cptValid = false;
            boolean functionValid = false;
            List previousPhaseElements = RefinementLinkExt.getRelatedTargetElements((CapellaElement)((CapellaElement)eObj), (EClass)FaPackage.Literals.COMPONENT_FUNCTIONAL_ALLOCATION);
            for (CapellaElement element : previousPhaseElements) {
                ComponentFunctionalAllocation exc = (ComponentFunctionalAllocation)element;
                AbstractFunction fct = exc.getFunction();
                if (fct != null) {
                    for (AbstractTrace traceFunction : fct.getIncomingTraces()) {
                        if (!(traceFunction.getSourceElement() instanceof AbstractFunction)) continue;
                        AbstractFunction targetFunction = (AbstractFunction)traceFunction.getSourceElement();
                        if (!EcoreUtil2.isOrIsContainedBy((EObject)fci.getFunction(), (EObject)targetFunction)) continue;
                        functionValid = true;
                    }
                }
                AbstractFunctionalBlock block = exc.getBlock();
                if (fct != null) {
                    for (AbstractTrace traceFunction : block.getIncomingTraces()) {
                        AbstractFunctionalBlock targetFunction;
                        if (!(traceFunction.getSourceElement() instanceof AbstractFunctionalBlock) || !((targetFunction = (AbstractFunctionalBlock)traceFunction.getSourceElement()) instanceof Component) || !(fci.getBlock() instanceof Component) || targetFunction != fci.getBlock() && !ComponentExt.isComponentAncestor((Component)((Component)targetFunction), (Component)((Component)fci.getBlock()))) continue;
                        cptValid = true;
                    }
                }
                if (!functionValid || !cptValid) continue;
                return ctx.createSuccessStatus();
            }
            if (previousPhaseElements.size() != 0) {
                return ctx.createFailureStatus(new Object[]{CapellaElementExt.getName((EObject)fci)});
            }
        }
        return ctx.createSuccessStatus();
    }
}

