/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.eclipse.capella.ui.trace.views.providers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;

public class CapellaModelFilter
extends ViewerFilter
implements ModifyListener {
    private Pattern _expPattern;
    private Viewer _viewer;

    public boolean select(Viewer viewer_p, Object parentElement_p, Object element_p) {
        if (this._viewer == null || this._viewer != viewer_p) {
            this._viewer = viewer_p;
        }
        if (element_p instanceof TraceableElement) {
            if (element_p instanceof AbstractNamedElement) {
                AbstractNamedElement element = (AbstractNamedElement)element_p;
                String name = element.getName();
                return this.checkPattern(element_p, name);
            }
            return true;
        }
        return false;
    }

    private boolean checkPattern(Object element_p, String name_p) {
        if (name_p == null || name_p.trim().equals("")) {
            return false;
        }
        if (this._expPattern == null) {
            return true;
        }
        if (this._viewer instanceof TreeViewer) {
            TreeViewer viewer = (TreeViewer)this._viewer;
            return this.checkPattern(viewer, element_p, name_p);
        }
        Matcher matcher = this._expPattern.matcher(name_p);
        if (this._expPattern.pattern().startsWith("*")) {
            return matcher.find();
        }
        return matcher.matches();
    }

    private boolean checkPattern(TreeViewer viewer_p, Object element_p, String name_p) {
        boolean flag = false;
        Object[] children = ((ITreeContentProvider)viewer_p.getContentProvider()).getChildren(element_p);
        Matcher matcher = this._expPattern.matcher(name_p);
        flag = this._expPattern.pattern().startsWith(".*") ? matcher.find() : matcher.matches();
        if (children != null) {
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractNamedElement element;
                String name;
                Object obj = objectArray[n2];
                if (element_p instanceof AbstractNamedElement && (name = (element = (AbstractNamedElement)element_p).getName()) != null) {
                    matcher = this._expPattern.matcher(name);
                    if (this._expPattern.pattern().startsWith(".*") && !flag) {
                        flag = matcher.find();
                    }
                    if (!flag) {
                        flag = matcher.matches();
                    }
                    if (flag) {
                        return true;
                    }
                    flag = this.checkPattern(viewer_p, obj, name);
                }
                ++n2;
            }
        }
        return flag;
    }

    public void modifyText(ModifyEvent modifyEvent) {
        int epos;
        int spos;
        Text txt = (Text)modifyEvent.widget;
        Object value = txt.getText();
        if (((String)value).length() == 0) {
            this._expPattern = null;
            if (this._viewer != null) {
                this._viewer.refresh();
            }
            return;
        }
        if (((String)value).contains(".")) {
            value = ((String)value).replace(".", "[.]");
        }
        if (((String)value).contains("\\") && !((String)value).endsWith("\\")) {
            spos = 0;
            epos = 0;
            while ((spos = ((String)value).indexOf("\\", epos)) != -1) {
                value = ((String)value).substring(epos, spos) + "[" + ((String)value).charAt(spos + 1) + "]" + ((String)value).substring(spos + 2);
                epos = spos + 2;
            }
        }
        value = ((String)value).replaceAll("[*]+", "*");
        if (((String)(value = ((String)value).replaceAll("^\\[*]", ".*"))).contains("[")) {
            spos = 0;
            epos = 0;
            while ((spos = ((String)value).indexOf("[", epos)) != -1) {
                value = ((String)value).substring(epos, ((String)value).indexOf("[", epos)).replace("*", ".*") + ((String)value).substring(spos);
                epos = ((String)value).indexOf("]", spos);
            }
            value = ((String)value).substring(0, ((String)value).lastIndexOf("]")) + ((String)value).substring(((String)value).lastIndexOf("]")).replace("*", ".*");
        } else {
            value = ((String)value).replace("*", ".*");
        }
        value = ((String)value).replaceAll("^\\[\\?]", ".");
        if (((String)value).contains("[")) {
            spos = 0;
            epos = 0;
            while ((spos = ((String)value).indexOf("[", epos)) != -1) {
                value = ((String)value).substring(epos, ((String)value).indexOf("[", epos)).replace("?", ".") + ((String)value).substring(spos);
                epos = ((String)value).indexOf("]", spos);
            }
            value = ((String)value).substring(0, ((String)value).lastIndexOf("]")) + ((String)value).substring(((String)value).lastIndexOf("]")).replace("?", ".");
        } else {
            value = ((String)value).replace("?", ".");
        }
        value = ((String)value).concat(".*");
        try {
            this._expPattern = Pattern.compile((String)value, 2);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (this._viewer != null) {
            this._viewer.setSelection(null);
            this._viewer.refresh();
        }
    }
}

