/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.handler.command;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.sirius.viewpoint.DRefreshable;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.mdsofa.common.activator.SolFaCommonActivator;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;
import org.polarsys.capella.common.mdsofa.common.helper.FileHelper;
import org.polarsys.capella.core.model.handler.command.ICapellaResourceHelper;

public class CapellaResourceHelper {
    public static final String CAPELLA_MODEL_FILE_EXTENSION = "capella";
    public static final String CAPELLA_FRAGMENT_FILE_EXTENSION = "capellafragment";
    public static final String LEGACY_CAPELLA_MODEL_FILE_EXTENSION = "melodymodeller";
    public static final String LEGACY_CAPELLA_FRAGMENT_FILE_EXTENSION = "melodyfragment";
    public static final Map<String, String> LEGACY_TO_MODERN_FILE_EXTENSIONS;
    public static final String AIRD_FRAGMENT_FILE_EXTENSION = "airdfragment";
    public static final String AIRD_SRM_FILE_EXTENSION = "srm";
    public static final String AIRD_FILE_EXTENSION = "aird";
    public static final String AFM_FILE_EXTENSION = "afm";
    public static final String FRAGMENTS_DEFAULT_FOLDER = "fragments";
    private static boolean __delegatedCapellaResourceHelperLoaded;
    private static ICapellaResourceHelper __delegatedCapellaResourceHelper;
    public static final String CAPELLA_PROJECT_NATURE = "org.polarsys.capella.project.nature";
    public static final String CAPELLA_LIBRARY_PROJECT_NATURE = "org.polarsys.capella.library.nature";
    public static final String CAPELLA_CONFIGURATION_PROJECT_NATURE = "org.polarsys.capella.core.preferences.project.nature.configNature";

    static {
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put(LEGACY_CAPELLA_FRAGMENT_FILE_EXTENSION, CAPELLA_FRAGMENT_FILE_EXTENSION);
        temp.put(LEGACY_CAPELLA_MODEL_FILE_EXTENSION, CAPELLA_MODEL_FILE_EXTENSION);
        LEGACY_TO_MODERN_FILE_EXTENSIONS = Collections.unmodifiableMap(temp);
        __delegatedCapellaResourceHelperLoaded = false;
    }

    public static boolean ensureResourceIsWritable(Resource resource) {
        boolean result = false;
        if (resource == null) {
            return result;
        }
        IFile file = EcoreUtil2.getFile((Resource)resource);
        result = file != null && file.isReadOnly() ? SolFaCommonActivator.getDefault().getUserEnforcedHelper().makeFileWritable(file).isOK() : true;
        return result;
    }

    private static boolean hasFileExtension(IResource resource, boolean ignoreFragment, String fragmentFileExtension, String modelFileExtension) {
        boolean result = false;
        if (resource == null || 1 != resource.getType()) {
            return result;
        }
        String fileExtension = resource.getFileExtension();
        result = modelFileExtension.equals(fileExtension);
        if (!result && !ignoreFragment) {
            result = fragmentFileExtension.equals(fileExtension);
        }
        return result;
    }

    public static boolean isAirdResource(IResource resource, boolean ignoreAirdFragment) {
        return CapellaResourceHelper.hasFileExtension(resource, ignoreAirdFragment, AIRD_FRAGMENT_FILE_EXTENSION, AIRD_FILE_EXTENSION);
    }

    public static boolean isAfmResource(IResource resource) {
        return CapellaResourceHelper.hasFileExtension(resource, true, AFM_FILE_EXTENSION, AFM_FILE_EXTENSION);
    }

    public static boolean isAirdResource(URI uri) {
        return uri != null && (AIRD_FILE_EXTENSION.equals(uri.fileExtension()) || AIRD_FRAGMENT_FILE_EXTENSION.equals(uri.fileExtension()));
    }

    public static boolean isRepresentationResource(URI uri) {
        return uri != null && AIRD_SRM_FILE_EXTENSION.equals(uri.fileExtension());
    }

    public static boolean isCapellaFragment(URI uri) {
        return uri != null ? CAPELLA_FRAGMENT_FILE_EXTENSION.equals(uri.fileExtension()) : false;
    }

    public static boolean isCapellaResource(IResource resource) {
        return CapellaResourceHelper.isCapellaResource(resource, false);
    }

    public static boolean isLegacyCapellaResource(IResource resource) {
        return CapellaResourceHelper.isLegacyCapellaResource(resource, false);
    }

    public static boolean isCapellaResource(IResource resource, boolean ignoreCapellaFragment) {
        return CapellaResourceHelper.hasFileExtension(resource, ignoreCapellaFragment, CAPELLA_FRAGMENT_FILE_EXTENSION, CAPELLA_MODEL_FILE_EXTENSION);
    }

    public static boolean isLegacyCapellaResource(IResource resource, boolean ignoreCapellaFragment) {
        return CapellaResourceHelper.hasFileExtension(resource, ignoreCapellaFragment, LEGACY_CAPELLA_FRAGMENT_FILE_EXTENSION, LEGACY_CAPELLA_MODEL_FILE_EXTENSION);
    }

    public static String getModernResourceExtension(String legacyExtension) {
        return LEGACY_TO_MODERN_FILE_EXTENSIONS.get(legacyExtension);
    }

    public static boolean isLegacyCapellaResourcePath(IPath path) {
        String fileExtension = path.getFileExtension();
        return CapellaResourceHelper.getModernResourceExtension(fileExtension) != null;
    }

    public static IPath convertLegacyResourcePathToModern(IPath path) {
        String legacyExtension = path.getFileExtension();
        String modernExtension = CapellaResourceHelper.getModernResourceExtension(legacyExtension);
        if (modernExtension != null) {
            return path.removeFileExtension().addFileExtension(modernExtension);
        }
        return path;
    }

    public static IResource renameLegacyResource(IResource capellaResource) {
        IFile legacyFile;
        if (CapellaResourceHelper.isLegacyCapellaResource(capellaResource) && (legacyFile = (IFile)capellaResource.getAdapter(IFile.class)) != null) {
            IWorkspace workspace = legacyFile.getWorkspace();
            IPath legacyPath = capellaResource.getFullPath();
            IPath modernPath = CapellaResourceHelper.convertLegacyResourcePathToModern(legacyPath);
            FileHelper.moveResource((IResource)legacyFile, (IPath)modernPath);
            return workspace.getRoot().getFile(modernPath);
        }
        return capellaResource;
    }

    public static boolean isCapellaResource(Object object) {
        return object instanceof Resource && CapellaResourceHelper.isCapellaResource((Resource)object);
    }

    public static boolean isCapellaResource(Resource resource) {
        return resource != null ? CapellaResourceHelper.isCapellaResource(resource.getURI()) : false;
    }

    public static boolean isCapellaResource(URI uri) {
        boolean isCapellaResource;
        if (uri == null) {
            return false;
        }
        if (!__delegatedCapellaResourceHelperLoaded) {
            __delegatedCapellaResourceHelper = CapellaResourceHelper.loadDelegatedCapellaResourceHelper();
        }
        boolean bl = isCapellaResource = __delegatedCapellaResourceHelper != null ? __delegatedCapellaResourceHelper.isCapellaResource(uri) : false;
        return isCapellaResource || CAPELLA_MODEL_FILE_EXTENSION.equals(uri.fileExtension()) || CapellaResourceHelper.isCapellaFragment(uri);
    }

    public static boolean isSemanticElement(Object object) {
        return object instanceof EObject && !CapellaResourceHelper.isSiriusElement(object);
    }

    private static boolean isSiriusElement(Object object) {
        EObject o;
        if (object instanceof EObject && (o = (EObject)object).eClass().getEPackage() == NotationPackage.eINSTANCE) {
            return true;
        }
        return object instanceof DRefreshable || object instanceof DRepresentationDescriptor;
    }

    public static boolean isSemanticElements(Collection<?> objects) {
        for (Object o : objects) {
            if (CapellaResourceHelper.isSemanticElement(o)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAirdElement(EObject eObject) {
        if (eObject instanceof InternalEObject) {
            InternalEObject internalEObject = (InternalEObject)eObject;
            if (internalEObject.eIsProxy() && (CapellaResourceHelper.isAirdResource(internalEObject.eProxyURI()) || CapellaResourceHelper.isRepresentationResource(internalEObject.eProxyURI()))) {
                return true;
            }
            Resource resource = eObject.eResource();
            if (resource != null && resource.getURI() != null && (CapellaResourceHelper.isAirdResource(resource.getURI()) || CapellaResourceHelper.isRepresentationResource(resource.getURI()))) {
                return true;
            }
        }
        return false;
    }

    public static Resource createCapellaResource(IProject project, String filename, TransactionalEditingDomain domain) {
        String fullPath = project.getFullPath().toString() + "/" + filename + ".capella";
        URI capellaModelURI = URI.createPlatformResourceURI((String)fullPath, (boolean)true);
        ResourceSet set = domain.getResourceSet();
        Resource xmiResource = set.createResource(capellaModelURI);
        return xmiResource;
    }

    private static ICapellaResourceHelper loadDelegatedCapellaResourceHelper() {
        ICapellaResourceHelper delegatedHelper = null;
        IConfigurationElement[] configurationElements = ExtensionPointHelper.getConfigurationElements((String)"org.polarsys.capella.core.model.handler", (String)"delegatedCapellaResourceHelper");
        if (configurationElements.length > 0) {
            delegatedHelper = (ICapellaResourceHelper)ExtensionPointHelper.createInstance((IConfigurationElement)configurationElements[0], (String)"class");
        }
        __delegatedCapellaResourceHelperLoaded = true;
        return delegatedHelper;
    }

    public static EAttribute getEditableAttribute(EObject selectedElement) {
        EAttribute attribute = null;
        if (selectedElement != null) {
            EStructuralFeature feature;
            if (selectedElement instanceof AbstractNamedElement) {
                attribute = ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME;
            } else if (selectedElement.eClass() != null && (feature = selectedElement.eClass().getEStructuralFeature("name")) != null && feature instanceof EAttribute) {
                attribute = (EAttribute)feature;
            }
        }
        return attribute;
    }

    public static boolean isCapellaProject(IProject targetProject) {
        try {
            return targetProject.hasNature(CAPELLA_PROJECT_NATURE) || targetProject.hasNature(CAPELLA_LIBRARY_PROJECT_NATURE);
        }
        catch (CoreException exception) {
            return false;
        }
    }

    public static boolean isCapellaProject(Resource resource) {
        IProject project;
        IFile file = WorkspaceSynchronizer.getFile((Resource)resource);
        if (file != null && (project = file.getProject()) != null) {
            return CapellaResourceHelper.isCapellaProject(project);
        }
        return false;
    }

    public static boolean isCapellaProject(URI uri) {
        try {
            if (uri.isPlatformResource()) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
                return CapellaResourceHelper.isCapellaProject(file.getProject());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static Resource getMainModelResource(EObject eObject) {
        Resource objRes = eObject.eResource();
        if (objRes != null) {
            if (CapellaResourceHelper.isCapellaFragment(objRes.getURI())) {
                Resource mainModelResource = EcoreUtil.getRootContainer((EObject)eObject, (boolean)true).eResource();
                if (mainModelResource != null) {
                    return mainModelResource;
                }
            } else {
                return objRes;
            }
        }
        return null;
    }

    public static boolean isProjectOfType(IProject project, Collection<String> natureIdsToMatch) {
        boolean result = false;
        if (natureIdsToMatch == null || natureIdsToMatch.isEmpty()) {
            return true;
        }
        try {
            String[] projectNatures = project.getDescription().getNatureIds();
            result = CapellaResourceHelper.matche(projectNatures, natureIdsToMatch);
        }
        catch (CoreException exception) {
            result = false;
        }
        return result;
    }

    public static boolean isProjectOfType(IProject project, String natureIdToMatch) {
        return natureIdToMatch == null || natureIdToMatch.equals("") ? true : CapellaResourceHelper.isProjectOfType(project, Collections.singleton(natureIdToMatch));
    }

    public static Collection<IProject> getAllProjectsOfType(String natureIdToMatch) {
        return CapellaResourceHelper.getAllProjectsOfType(Collections.singleton(natureIdToMatch));
    }

    public static Collection<IProject> getAllProjectsOfType(Collection<String> natureIdsToMatch) {
        HashSet<IProject> result = new HashSet<IProject>();
        IWorkspace root = ResourcesPlugin.getWorkspace();
        IProject[] projects = root.getRoot().getProjects();
        boolean shouldBeFilteredWithNature = natureIdsToMatch != null && !natureIdsToMatch.isEmpty();
        IProject project = null;
        boolean keep = false;
        int i = 0;
        while (i < projects.length) {
            keep = false;
            project = projects[i];
            keep = project.isAccessible();
            if (keep && shouldBeFilteredWithNature) {
                keep = CapellaResourceHelper.isProjectOfType(project, natureIdsToMatch);
            }
            if (keep) {
                result.add(project);
            }
            ++i;
        }
        return result;
    }

    private static boolean matche(String[] a, Collection<String> b) {
        boolean result = false;
        String[] stringArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (b.contains(str)) {
                result = true;
                break;
            }
            ++n2;
        }
        return result;
    }
}

