/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.handler.command;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.polarsys.capella.core.model.handler.ModelHandlerPlugin;
import org.polarsys.capella.core.model.handler.command.Messages;

public class CapellaResourceNamingHelper {
    protected static final char[] INVALID_CAPELLA_RESOURCE_CHARACTERS = new char[]{'#', '%', '$'};

    private CapellaResourceNamingHelper() {
    }

    public static IStatus validateName(String name, int typeMask) {
        char[] invalidChars;
        IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
        IStatus workspaceStatus = workspace.validateName(name, typeMask);
        if (!workspaceStatus.isOK()) {
            return workspaceStatus;
        }
        char[] cArray = invalidChars = INVALID_CAPELLA_RESOURCE_CHARACTERS;
        int n = invalidChars.length;
        int n2 = 0;
        while (n2 < n) {
            char invalidChar = cArray[n2];
            if (name.indexOf(invalidChar) != -1) {
                String message = NLS.bind((String)Messages.CapellaResourceNamingHelper_invalidCharInName, (Object)String.valueOf(invalidChar), (Object)name);
                return new Status(4, ModelHandlerPlugin.PLUGIN_ID, message);
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }
}

