/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.sirius.validation.ddiagram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.platform.sirius.sirius.validation.parser.helper.DescriptionLinkParserHandler;
import org.polarsys.capella.core.platform.sirius.sirius.validation.parser.helper.MissingElementHandler;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class CapellaElementInDescriptionExistanceCheck
extends AbstractValidationRule {
    protected Logger logger = ReportManagerRegistry.getInstance().subscribe("Model Validation");
    protected StringBuilder desc = null;

    public List<IStatus> validateElement(EObject element, String description, IValidationContext ctx) {
        ArrayList<IStatus> result = new ArrayList<IStatus>();
        MissingElementHandler linkParser = new MissingElementHandler(element, ctx);
        DescriptionLinkParserHandler descriptionParser = new DescriptionLinkParserHandler(element, ctx, linkParser);
        List<IStatus> exceptions = descriptionParser.process(description);
        List<IStatus> parserResult = linkParser.getResult();
        result.addAll(parserResult);
        result.addAll(exceptions);
        return result;
    }

    public IStatus validate(IValidationContext ctx) {
        EObject target = ctx.getTarget();
        ArrayList<IStatus> result = new ArrayList<IStatus>();
        if (target != null && target instanceof CapellaElement) {
            CapellaElement capellaElement = (CapellaElement)target;
            String description = capellaElement.getDescription();
            if (description != null && !description.isEmpty()) {
                result.addAll(this.validateElement((EObject)capellaElement, description, ctx));
            }
            Session.of((EObject)target).ifPresent(session -> {
                Collection representationDescriptors = DialectManager.INSTANCE.getRepresentationDescriptors(target, session);
                for (DRepresentationDescriptor dRepresentationDescriptor : representationDescriptors) {
                    String documentation = dRepresentationDescriptor.getDocumentation();
                    List<IStatus> currentRepresentationStatus = this.validateElement((EObject)dRepresentationDescriptor, documentation, ctx);
                    result.addAll(currentRepresentationStatus);
                }
            });
        }
        IStatus returnedStatus = null;
        returnedStatus = result.isEmpty() ? ctx.createSuccessStatus() : (result.size() == 1 ? (IStatus)result.get(0) : ConstraintStatus.createMultiStatus((IValidationContext)ctx, result));
        return returnedStatus;
    }
}

