/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.sirius.validation.ddiagram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.tools.internal.validation.constraints.ImagePathConstraint;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.model.handler.validation.CapellaDiagnostician;

public class ImagePathInDiagramCheck
extends ImagePathConstraint {
    public IStatus validate(IValidationContext ctx) {
        boolean calledByCapella = Stream.of(Thread.currentThread().getStackTrace()).filter(ste -> ste.getClassName().equals(CapellaDiagnostician.class.getName())).findFirst().isPresent();
        if (!calledByCapella) {
            return ctx.createSuccessStatus();
        }
        EObject target = ctx.getTarget();
        ArrayList failureStatuses = new ArrayList();
        if (target instanceof CapellaElement) {
            Session.of((EObject)target).ifPresent(session -> {
                Collection representations = DialectManager.INSTANCE.getRepresentations(target, session);
                for (DRepresentation dRepresentation : representations) {
                    Iterable iterable = () -> dRepresentation.eAllContents();
                    List workspaceImages = StreamSupport.stream(iterable.spliterator(), false).filter(WorkspaceImage.class::isInstance).map(WorkspaceImage.class::cast).collect(Collectors.toList());
                    for (WorkspaceImage workspaceImage : workspaceImages) {
                        this.validateWorkspaceImagePath(workspaceImage, ctx, failureStatuses);
                    }
                }
            });
        }
        IStatus returnedStatus = null;
        returnedStatus = failureStatuses.isEmpty() ? ctx.createSuccessStatus() : (failureStatuses.size() == 1 ? (IStatus)failureStatuses.get(0) : ConstraintStatus.createMultiStatus((IValidationContext)ctx, failureStatuses));
        return returnedStatus;
    }
}

