/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.sirius.validation.parser.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.core.model.utils.saxparser.SaxParserHelper;
import org.polarsys.capella.core.platform.sirius.sirius.validation.ddiagram.LinkDescription;
import org.polarsys.capella.core.platform.sirius.sirius.validation.parser.helper.DescriptionLinkParserHandler;
import org.polarsys.capella.core.platform.sirius.sirius.validation.parser.helper.DescriptionParserHelper;
import org.polarsys.capella.core.platform.sirius.sirius.validation.parser.helper.ILinkParser;

public class MissingElementHandler
implements ILinkParser {
    private EObject element;
    private IValidationContext ctx;
    private List<IStatus> result = new ArrayList<IStatus>();
    private List<LinkDescription> parsedLinks = new ArrayList<LinkDescription>();

    public MissingElementHandler(EObject element, IValidationContext ctx) {
        this.element = element;
        this.ctx = ctx;
    }

    public List<IStatus> getResult() {
        return this.result;
    }

    @Override
    public void handleParsedLink(LinkDescription parsedLink) {
        if (parsedLink.getTargetElement() == null && parsedLink.getHref().startsWith("hlink://")) {
            String elementName = DescriptionParserHelper.getElementName(this.element);
            String elementId = parsedLink.getHref().replace("hlink://", "");
            if (!this.parsedLinks.contains(parsedLink)) {
                this.parsedLinks.add(parsedLink);
                Object failureMessage = "(Hyperlink) The model/diagram element with label \"" + parsedLink.getName() + "\" (id: " + elementId + ") can not be found for the rich text description of the element " + elementName;
                failureMessage = SaxParserHelper.unescapeSpecialCharacter((String)failureMessage);
                this.result.add((IStatus)ConstraintStatus.createStatus((IValidationContext)this.ctx, (EObject)this.element, (Collection)this.ctx.getResultLocus(), (String)"{0}", (Object[])new Object[]{failureMessage}));
            } else {
                List updatedResult = this.result.stream().map(sts -> {
                    if (sts.getMessage().contains(elementId)) {
                        String name = DescriptionLinkParserHandler.extractName(sts.getMessage());
                        Object failureMessage = "(Hyperlink) The model/diagram elements with label \"" + name + "\", ... (id: " + elementId + ") can not be found for the rich text description of the element " + elementName;
                        failureMessage = SaxParserHelper.unescapeSpecialCharacter((String)failureMessage);
                        return ConstraintStatus.createStatus((IValidationContext)this.ctx, (EObject)this.element, (Collection)this.ctx.getResultLocus(), (String)"{0}", (Object[])new Object[]{failureMessage});
                    }
                    return sts;
                }).collect(Collectors.toList());
                this.result.clear();
                this.result.addAll(updatedResult);
            }
        }
    }
}

