/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.project;

import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.platform.sirius.ui.project.CapellaProjectActivator;
import org.polarsys.capella.core.platform.sirius.ui.project.Messages;
import org.polarsys.capella.core.platform.sirius.ui.project.NewModelWizardPage;
import org.polarsys.capella.core.platform.sirius.ui.project.internal.CapellaProjectContentsLocationArea;
import org.polarsys.capella.core.platform.sirius.ui.project.internal.ProjectContentsLocationArea;
import org.polarsys.capella.core.platform.sirius.ui.project.internal.WizardNewProjectCreationPage;
import org.polarsys.capella.core.platform.sirius.ui.project.operations.ProjectSessionCreationHelper;
import org.polarsys.capella.core.platform.sirius.ui.project.operations.SessionCreationHelper;
import org.polarsys.capella.core.preferences.configuration.project.ui.wizards.ReferecedConfigurationProjectSelectionPage;
import org.polarsys.capella.core.sirius.ui.actions.OpenSessionAction;

public class NewProjectWizard
extends BasicNewResourceWizard {
    protected static final int STEP_TICK_COUNT = 100;
    private static final Logger logger = ReportManagerRegistry.getInstance().subscribe("User Interface");
    protected WizardNewProjectCreationPage _localProjectDescriptionPage;
    protected NewModelWizardPage modelPage;
    private SortedMap<Viewpoint, Boolean> viewpointsMap = new TreeMap<Viewpoint, Boolean>((Comparator<Viewpoint>)new ViewpointRegistry.ViewpointComparator());
    private WizardPage viewpointWizardPage;
    private ReferecedConfigurationProjectSelectionPage referencedConfigurationProjectPage;

    public void addPages() {
        this._localProjectDescriptionPage = this.createLocalProjectDescriptionPage();
        this.addPage((IWizardPage)this._localProjectDescriptionPage);
        this.createLogicPages();
        this.viewpointWizardPage = ViewpointSelection.createWizardPage((String)"capella", this.viewpointsMap);
        this.addPage((IWizardPage)this.viewpointWizardPage);
        this.createReferencedConfigurationProjectsPage();
    }

    protected void createReferencedConfigurationProjectsPage() {
        this.referencedConfigurationProjectPage = new ReferecedConfigurationProjectSelectionPage(Messages.getString("NewModelWizard.title"), new String[]{"org.polarsys.capella.core.preferences.project.nature.configNature"});
        this.addPage((IWizardPage)this.referencedConfigurationProjectPage);
    }

    protected void createLogicPages() {
        this.modelPage = this.createModelPage();
        this.addPage((IWizardPage)this.modelPage);
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        return currentPage.isPageComplete();
    }

    protected WizardNewProjectCreationPage createLocalProjectDescriptionPage() {
        WizardNewProjectCreationPage mainPage = new WizardNewProjectCreationPage("CapellaProjNewPage"){

            @Override
            protected ProjectContentsLocationArea handleDefaultProjectLocation(Composite parent_p) {
                return new CapellaProjectContentsLocationArea(this.getErrorReporter(), parent_p);
            }
        };
        mainPage.setInitialProjectName(null);
        mainPage.setDescription(Messages.getString("NewProjectWizard.description"));
        mainPage.setTitle(Messages.getString("NewProjectWizard.title"));
        return mainPage;
    }

    protected CapellaProjectHelper.ProjectApproach getProjectApproach() {
        return this._localProjectDescriptionPage.getProjectApproachSelection();
    }

    protected NewModelWizardPage createModelPage() {
        NewModelWizardPage modelPage = new NewModelWizardPage("model.creation.page");
        modelPage.setDescription(Messages.getString("NewModelWizard.description"));
        modelPage.setTitle(Messages.getString("NewModelWizard.title"));
        return modelPage;
    }

    protected IWizardPage getLocalProjectDescriptionPage() {
        return this._localProjectDescriptionPage;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        if (this.modelPage != null && this.modelPage == nextPage) {
            String projectName = this.getEclipseProjectName();
            this.modelPage.setModelNameFieldValue(projectName);
        }
        return nextPage;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setWindowTitle(Messages.getString("NewProjectWizard.window.title"));
        ImageDescriptor descriptor = CapellaProjectActivator.getDefault().getImageDescriptor("projectWizard.png");
        if (descriptor == null) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        this.setDefaultPageImageDescriptor(descriptor);
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor_p) throws InvocationTargetException, InterruptedException {
                    IPath newPath;
                    IPath defaultPath = Platform.getLocation();
                    if (defaultPath.equals((Object)(newPath = NewProjectWizard.this._localProjectDescriptionPage.getLocationPath()))) {
                        newPath = null;
                    }
                    List referencedProjects = NewProjectWizard.this.referencedConfigurationProjectPage.getSelectedConfigurationsProjects();
                    SessionCreationHelper helper = NewProjectWizard.this.createSessionCreationHelper();
                    Session session = helper.createFullProject(NewProjectWizard.this.getEclipseProjectName(), newPath, referencedProjects, NewProjectWizard.this.getSelectedViewpoints(), monitor_p);
                    OpenSessionAction.openActivityExplorer((Session)session);
                }
            });
        }
        catch (InvocationTargetException exception_p) {
            StringBuilder loggerMessage = new StringBuilder("NewProjectWizard.performFinish(..) _ ");
            logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
            return false;
        }
        catch (InterruptedException exception_p) {
            StringBuilder loggerMessage = new StringBuilder("NewProjectWizard.performFinish(..) _ ");
            logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
            return false;
        }
        return true;
    }

    protected SessionCreationHelper createSessionCreationHelper() {
        return new ProjectSessionCreationHelper(this.modelPage.isEpbsSelected(), this.modelPage.isOpaSelected(), this.getProjectApproach());
    }

    protected Set<Viewpoint> getSelectedViewpoints() {
        HashSet<Viewpoint> viewpoints = null;
        if (this.viewpointWizardPage.isPageComplete()) {
            viewpoints = new HashSet<Viewpoint>(0);
            for (Map.Entry<Viewpoint, Boolean> entry : this.viewpointsMap.entrySet()) {
                if (!entry.getValue().booleanValue()) continue;
                viewpoints.add(entry.getKey());
            }
        } else {
            viewpoints = ViewpointSelection.getViewpoints((String)"capella");
        }
        return viewpoints;
    }

    protected String getEclipseProjectName() {
        return this._localProjectDescriptionPage.getProjectName();
    }
}

