/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class SimpleOrientedGraph<T> {
    protected Map<T, List<T>> graph;

    public SimpleOrientedGraph() {
        this.graph = new HashMap<T, List<T>>();
    }

    public SimpleOrientedGraph(Map<T, List<T>> graph) {
        this.graph = graph;
    }

    public boolean isAConnectedGraph() {
        if (!this.graph.isEmpty()) {
            T first = this.graph.keySet().iterator().next();
            HashSet<Object> coloredNodes = new HashSet<Object>();
            Stack<Object> currentStack = new Stack<Object>();
            currentStack.push(first);
            coloredNodes.add(first);
            while (!currentStack.isEmpty()) {
                Object currentNode = currentStack.pop();
                for (Object aNeighbour : this.getNotOrientedNeighbours(currentNode)) {
                    if (coloredNodes.contains(aNeighbour)) continue;
                    coloredNodes.add(aNeighbour);
                    currentStack.push(aNeighbour);
                }
            }
            for (T aNode : this.graph.keySet()) {
                if (coloredNodes.contains(aNode)) continue;
                return false;
            }
        }
        return true;
    }

    public Set<T> getNotOrientedNeighbours(T node) {
        HashSet<T> returnedList = new HashSet<T>();
        if (this.graph.containsKey(node)) {
            returnedList.addAll((Collection)this.graph.get(node));
        }
        for (Map.Entry<T, List<T>> me : this.graph.entrySet()) {
            if (!me.getValue().contains(node)) continue;
            returnedList.add(me.getKey());
        }
        return returnedList;
    }

    public void addNode(T node, T neighbour) {
        if (this.graph.containsKey(node)) {
            this.graph.get(node).add(neighbour);
        } else {
            ArrayList<T> newList = new ArrayList<T>();
            newList.add(neighbour);
            this.graph.put(node, newList);
        }
    }

    public boolean isEmpty() {
        return this.graph.isEmpty();
    }

    public Set<T> getSourceNodes() {
        HashSet<T> returnedSet = new HashSet<T>(this.graph.keySet());
        for (Map.Entry<T, List<T>> me : this.graph.entrySet()) {
            returnedSet.removeAll((Collection)me.getValue());
        }
        return returnedSet;
    }

    public boolean containsACycle(T aNode, Set<T> visitedNodes) {
        HashSet<T> nodes = new HashSet<T>(visitedNodes);
        nodes.add(aNode);
        if (this.graph.containsKey(aNode)) {
            for (T aNext : this.graph.get(aNode)) {
                if (nodes.contains(aNext)) {
                    return true;
                }
                if (!this.containsACycle(aNext, nodes)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValid() {
        if (!this.isAConnectedGraph()) {
            return false;
        }
        Set<T> sourceNodes = this.getSourceNodes();
        if (sourceNodes.isEmpty()) {
            return false;
        }
        for (T aSourceNode : sourceNodes) {
            if (!this.containsACycle(aSourceNode, new HashSet())) continue;
            return false;
        }
        return true;
    }

    public Map<T, List<T>> getGraph() {
        return this.graph;
    }
}

