/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.re.updateconnections.ui;

import com.google.common.collect.Iterators;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.diffmerge.generic.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.generic.api.scopes.ITreeDataScope;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CatalogElementLink;
import org.polarsys.capella.core.data.cs.PhysicalLinkEnd;
import org.polarsys.capella.core.data.fa.ComponentExchangeEnd;
import org.polarsys.capella.core.re.updateconnections.ui.ConnectedCatalogElementsScope;
import org.polarsys.capella.core.re.updateconnections.ui.Connection;
import org.polarsys.capella.core.re.updateconnections.ui.ConnectionMatcher;
import org.polarsys.capella.core.re.updateconnections.ui.RelationshipMatchID;

public class UpdateConnectionsMatchPolicy
implements IMatchPolicy<EObject> {
    private final Map<EObject, EObject> rpl2rec;
    private final ConnectedCatalogElementsScope rplScope;
    private final ConnectedCatalogElementsScope recScope;
    private final ConnectionMatcher connectionMatcher;

    public UpdateConnectionsMatchPolicy(ConnectedCatalogElementsScope rplScope, ConnectedCatalogElementsScope recScope, ConnectionMatcher connectionMatcher) {
        this.recScope = recScope;
        this.rplScope = rplScope;
        this.connectionMatcher = connectionMatcher;
        this.rpl2rec = this.buildRpl2RecMap(rplScope.getLeftCatalogElement(), rplScope.getRightCatalogElement());
    }

    private Map<EObject, EObject> buildRpl2RecMap(CatalogElement leftRpl, CatalogElement rightRpl) {
        HashMap<EObject, EObject> result = new HashMap<EObject, EObject>();
        Iterator rplLinks = Iterators.concat((Iterator)leftRpl.getOwnedLinks().iterator(), (Iterator)rightRpl.getOwnedLinks().iterator());
        while (rplLinks.hasNext()) {
            CatalogElementLink nextLink = (CatalogElementLink)rplLinks.next();
            result.put(nextLink.getTarget(), nextLink.getOrigin().getTarget());
        }
        return result;
    }

    public ConnectedCatalogElementsScope getRplScope() {
        return this.rplScope;
    }

    public ConnectedCatalogElementsScope getRecScope() {
        return this.recScope;
    }

    public Object getMatchID(EObject element, ITreeDataScope<EObject> scope) {
        Connection rplConnection = this.rplScope.adapt(element);
        if (rplConnection != null) {
            return this.connectionMatcher.getMatchID(rplConnection, scope, this);
        }
        Connection recConnection = this.recScope.adapt(element);
        if (recConnection != null) {
            return this.connectionMatcher.getMatchID(recConnection, scope, this);
        }
        if (element instanceof AbstractTrace) {
            TraceableElement sourceElement = ((AbstractTrace)element).getSourceElement();
            TraceableElement targetElement = ((AbstractTrace)element).getTargetElement();
            return new RelationshipMatchID(this.getMatchID((EObject)sourceElement, scope), this.getMatchID((EObject)targetElement, scope), element.getClass());
        }
        if (element instanceof PhysicalLinkEnd) {
            PhysicalLinkEnd end = (PhysicalLinkEnd)element;
            return new RelationshipMatchID(this.getMatchID((EObject)end.getPart(), scope), this.getMatchID((EObject)end.getPort(), scope), element.getClass());
        }
        if (element instanceof ComponentExchangeEnd) {
            ComponentExchangeEnd end = (ComponentExchangeEnd)element;
            return new RelationshipMatchID(this.getMatchID((EObject)end.getPart(), scope), this.getMatchID((EObject)end.getPort(), scope), element.getClass());
        }
        EObject result = this.rpl2rec.get(element);
        if (result == null) {
            result = element;
        }
        return result;
    }

    public Comparator<?> getMatchIDComparator() {
        return null;
    }

    public boolean keepMatchIDs() {
        return false;
    }
}

