/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.re.updateconnections.ui.tester;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CatalogElementKind;
import org.polarsys.capella.common.re.CatalogElementLink;
import org.polarsys.capella.common.re.RePackage;

public class RePropertyTester
extends PropertyTester {
    public static final String PROPERTY_IS_RPL_CATALOG_ELEMENT = "isRplCatalogElement";
    public static final String PROPERTY_IS_RPL_ELEMENT = "isRplElement";
    public static final String PROPERTY_IS_REC_CATALOG_ELEMENT = "isRecCatalogElement";
    public static final String PROPERTY_IS_REC_ELEMENT = "isRecElement";
    public static final String PROPERTY_IS_UPDATE_CONNECTIONS_ENABLED = "isUpdateConnectionsEnabled";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        switch (property) {
            case "isRplCatalogElement": {
                return this.isRplCatalogElement(receiver);
            }
            case "isRplElement": {
                return this.isRplElement(receiver);
            }
            case "isRecCatalogElement": {
                return this.isRecCatalogElement(receiver);
            }
            case "isRecElement": {
                return this.isRecElement(receiver);
            }
            case "isUpdateConnectionsEnabled": {
                return this.isUpdateConnectionsEnabled(receiver);
            }
        }
        throw new IllegalArgumentException("Unknown property: " + property);
    }

    private boolean isUpdateConnectionsEnabled(Object receiver) {
        Object[] selected = ((Collection)receiver).toArray();
        if (selected.length == 2) {
            if (selected[0] instanceof IDiagramElementEditPart) {
                selected[0] = ((IDiagramElementEditPart)selected[0]).resolveTargetSemanticElement();
            }
            if (selected[1] instanceof IDiagramElementEditPart) {
                selected[1] = ((IDiagramElementEditPart)selected[1]).resolveTargetSemanticElement();
            }
            if (selected[0] instanceof EObject && selected[1] instanceof EObject) {
                Collection<CatalogElement> sel0CatalogElements = this.getCatalogElements((EObject)selected[0], Predicates.forKind(CatalogElementKind.RPL));
                Collection<CatalogElement> sel1CatalogElements = this.getCatalogElements((EObject)selected[1], Predicates.forKind(CatalogElementKind.RPL));
                if (selected[0] instanceof CatalogElement) {
                    sel0CatalogElements.add((CatalogElement)selected[0]);
                }
                if (selected[1] instanceof CatalogElement) {
                    sel1CatalogElements.add((CatalogElement)selected[1]);
                }
                sel1CatalogElements.removeAll(sel0CatalogElements);
                return !sel0CatalogElements.isEmpty() && !sel1CatalogElements.isEmpty();
            }
        }
        return false;
    }

    private boolean isRecElement(Object receiver) {
        if (receiver instanceof EObject) {
            for (CatalogElementLink link : EObjectExt.getReferencers((EObject)((EObject)receiver), (EReference)RePackage.Literals.CATALOG_ELEMENT_LINK__TARGET)) {
                if (!this.isRecCatalogElement(link.getSource())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRecCatalogElement(Object receiver) {
        if (receiver instanceof CatalogElement) {
            CatalogElement ce = (CatalogElement)receiver;
            return ce.getKind() == CatalogElementKind.REC || ce.getKind() == CatalogElementKind.REC_RPL;
        }
        return false;
    }

    private boolean isRplElement(Object receiver) {
        if (receiver instanceof EObject) {
            for (CatalogElementLink link : EObjectExt.getReferencers((EObject)((EObject)receiver), (EReference)RePackage.Literals.CATALOG_ELEMENT_LINK__TARGET)) {
                if (!this.isRplCatalogElement(link.getSource())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRplCatalogElement(Object receiver) {
        if (receiver instanceof CatalogElement) {
            CatalogElement ce = (CatalogElement)receiver;
            return ce.getKind() == CatalogElementKind.RPL || ce.getKind() == CatalogElementKind.REC_RPL;
        }
        return false;
    }

    private Collection<CatalogElement> getCatalogElements(EObject member, Predicate<CatalogElement> filter) {
        List links = EObjectExt.getReferencers((EObject)member, (EReference)RePackage.Literals.CATALOG_ELEMENT_LINK__TARGET);
        ArrayList<CatalogElement> result = new ArrayList<CatalogElement>();
        for (CatalogElementLink link : links) {
            if (filter != null && !filter.apply((Object)link.getSource())) continue;
            result.add(link.getSource());
        }
        return result;
    }

    public static class Predicates {
        public static final Predicate<CatalogElement> forKind(final CatalogElementKind kind) {
            return new Predicate<CatalogElement>(){

                public boolean apply(CatalogElement input) {
                    return input.getKind() == kind;
                }
            };
        }
    }
}

