/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.flexibility.wizards.renderer;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.wizards.renderer.AbstractRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;
import org.polarsys.capella.common.flexibility.wizards.ui.util.StatusLabelHelper;

public class CheckboxRenderer
extends AbstractRenderer {
    Button dataExport;
    protected Label validateControl;
    protected Composite rootControl;

    @Override
    public void performRender(Composite parent, final IRendererContext rendererContext) {
        final IProperty property = rendererContext.getProperty(this);
        this.rootControl = new Composite(parent, 0);
        if (parent.getLayout() instanceof GridLayout) {
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.makeColumnsEqualWidth = false;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            GridData data = new GridData(3);
            this.rootControl.setLayoutData((Object)data);
            this.rootControl.setLayout((Layout)layout);
        } else {
            this.rootControl.setLayout((Layout)new FillLayout(256));
        }
        this.dataExport = new Button(this.rootControl, 32);
        if (!Boolean.FALSE.equals(rendererContext.getParameter("PARAMETER_RENDER_LABEL"))) {
            this.dataExport.setText(property.getName());
        }
        this.dataExport.setToolTipText(property.getDescription());
        this.dataExport.setData((Object)property);
        this.dataExport.setEnabled(property.isEnabled(rendererContext.getPropertyContext()));
        this.dataExport.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean newValue = ((Button)e.widget).getSelection();
                Boolean value = newValue;
                CheckboxRenderer.this.changeValue(property, rendererContext, value);
                CheckboxRenderer.this.updatedValue(property, rendererContext, value);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.validateControl = this.createImageControl(this.rootControl);
        StatusLabelHelper.updateImage(Status.OK_STATUS, this.validateControl);
    }

    private Label createImageControl(Composite parent) {
        return new Label(parent, 0);
    }

    @Override
    public void initialize(IProperty property, IRendererContext propertyContext) {
        Object value = propertyContext.getPropertyContext().getDefaultValue(property);
        this.updatedValue(property, propertyContext, value);
    }

    @Override
    public void updatedValue(IProperty property, IRendererContext rendererContext, Object newValue) {
        if (this.isDisposed()) {
            return;
        }
        IProperty prop = rendererContext.getProperty(this);
        if (property.equals(prop)) {
            Object value = property.toType(newValue, rendererContext.getPropertyContext());
            IStatus status = property.validate(value, rendererContext.getPropertyContext());
            StatusLabelHelper.updateTooltip(status, this.validateControl, false);
            StatusLabelHelper.updateImage(status, this.validateControl);
            if (!this.dataExport.isDisposed()) {
                this.dataExport.setSelection(Boolean.valueOf(newValue.toString()).booleanValue());
                this.dataExport.setEnabled(prop.isEnabled(rendererContext.getPropertyContext()));
            }
        }
    }

    @Override
    public void dispose(IRendererContext context) {
        super.dispose(context);
        if (this.dataExport != null) {
            this.dataExport.dispose();
        }
        if (this.validateControl != null) {
            this.validateControl.dispose();
        }
    }
}

