/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.flexibility.wizards.renderer;

import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.common.flexibility.wizards.Activator;
import org.polarsys.capella.common.flexibility.wizards.renderer.TextRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;

public class CopyTextRenderer
extends TextRenderer {
    Label copyButton;

    @Override
    protected boolean isImage() {
        return false;
    }

    @Override
    protected void initializeControls(final Composite parent, IRendererContext context) {
        if (this.isCopyButton()) {
            this.copyButton = new Label(this.rootTextControl, 0);
            this.copyButton.setToolTipText("Copy to clipboard");
            this.copyButton.setImage(Activator.getDefault().getImage("full/etool16/copy.gif"));
            this.copyButton.addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                    CopyTextRenderer.this.proceedCopy(parent.getShell());
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseDoubleClick(MouseEvent e) {
                }
            });
        }
        super.initializeControls(parent, context);
    }

    @Override
    protected void setBackgroundTextControl(Color color) {
        super.setBackgroundTextControl(color);
        if (this.isCopyButton()) {
            this.copyButton.setBackground(color);
        }
    }

    @Override
    protected int getNbColumn() {
        return super.getNbColumn();
    }

    @Override
    protected int getNbTextColumn() {
        return super.getNbTextColumn() + 1;
    }

    protected void proceedCopy(Shell shell) {
        Clipboard cb = new Clipboard(shell.getDisplay());
        TextTransfer textTransfer = TextTransfer.getInstance();
        cb.setContents(new Object[]{this.textControl.getText()}, new Transfer[]{textTransfer});
    }

    protected boolean isCopyButton() {
        return true;
    }

    @Override
    public void dispose(IRendererContext context) {
        super.dispose(context);
        if (this.copyButton != null) {
            this.copyButton.dispose();
        }
    }
}

