/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.validation.property;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.helpers.capellacore.services.GeneralizableElementExt;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class TypeOfDefaultAndNullValueForProperty
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        if (eObj instanceof Property && eObj.eContainer() instanceof Class) {
            DataValue nullValue;
            Class container = (Class)eObj.eContainer();
            Property property = (Property)eObj;
            DataValue defaultValue = property.getOwnedDefaultValue();
            if (!this.hasValidValue(defaultValue, property)) {
                IStatus status = ctx.createFailureStatus(new Object[]{"default", property.getName(), container.getName()});
                statuses.add(status);
            }
            if (!this.hasValidValue(nullValue = property.getOwnedNullValue(), property)) {
                IStatus status = ctx.createFailureStatus(new Object[]{"null", property.getName(), container.getName()});
                statuses.add(status);
            }
        }
        if (statuses.isEmpty()) {
            return ctx.createSuccessStatus();
        }
        return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
    }

    private boolean hasValidValue(DataValue value, Property property) {
        if (value == null) {
            return true;
        }
        Type valueType = value.getType();
        Type propertyType = property.getType();
        if (valueType == null) {
            return true;
        }
        if (valueType == propertyType) {
            return true;
        }
        if (propertyType instanceof GeneralizableElement) {
            GeneralizableElement genPropertyType = (GeneralizableElement)propertyType;
            List superDataTypes = GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)genPropertyType);
            return superDataTypes.contains(valueType);
        }
        return false;
    }
}

