/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.appenders.usage.util;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import org.polarsys.capella.common.tools.report.appenders.usage.util.UsageMonitoring;

public class UsageFormatter {
    private static final String ENCODING = StandardCharsets.UTF_8.toString();
    private static final int DATA_COUNT = 7;
    private static final String DATA_SEPARATOR = ";";

    public static String format(UsageMonitoring monitoring) {
        StringBuilder sb = new StringBuilder(7);
        sb.append(UsageFormatter.encode(monitoring.getApplicationName()) + DATA_SEPARATOR);
        sb.append(UsageFormatter.encode(monitoring.getApplicationVersion()) + DATA_SEPARATOR);
        sb.append(UsageFormatter.encode(monitoring.getEventName()) + DATA_SEPARATOR);
        sb.append(UsageFormatter.encode(monitoring.getEventContext()) + DATA_SEPARATOR);
        sb.append(UsageFormatter.encode(monitoring.getEventStatus().toString()) + DATA_SEPARATOR);
        sb.append(UsageFormatter.encode(monitoring.getAddendum()));
        return sb.toString();
    }

    public static UsageMonitoring parse(String message) throws Exception {
        String[] parts = message.split(DATA_SEPARATOR, -1);
        if (parts.length != 7) {
            throw new ParseException("The monitoring message must contains 7 elements", 0);
        }
        String applicationName = UsageFormatter.decode(parts[1]);
        String applicationVersion = UsageFormatter.decode(parts[2]);
        String eventName = UsageFormatter.decode(parts[3]);
        String eventContext = UsageFormatter.decode(parts[4]);
        String eventStatusValue = UsageFormatter.decode(parts[5]);
        String addendum = UsageFormatter.decode(parts[6]);
        UsageMonitoring.EventStatus eventStatus = null;
        UsageMonitoring.EventStatus[] eventStatusArray = UsageMonitoring.EventStatus.values();
        int n = eventStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            UsageMonitoring.EventStatus constant = eventStatusArray[n2];
            if (eventStatusValue == constant.toString()) {
                eventStatus = constant;
                break;
            }
            ++n2;
        }
        return new UsageMonitoring(applicationName, applicationVersion, eventName, eventContext, eventStatus, addendum);
    }

    private static String encode(String text) {
        try {
            return URLEncoder.encode(text, ENCODING);
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String decode(String text) {
        try {
            return URLDecoder.decode(text, ENCODING);
        }
        catch (Exception e) {
            return "";
        }
    }
}

