/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.validation.ui.ide.quickfix;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewHelper;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.handler.ReportMarkerResolution;
import org.polarsys.capella.core.validation.ui.ide.PluginActivator;
import org.polarsys.capella.core.validation.ui.ide.internal.quickfix.MarkerResolutionCache;

public abstract class AbstractCapellaMarkerResolution
extends ReportMarkerResolution {
    protected String label = null;
    protected String desc = null;
    protected String imgKey = null;
    protected String contributorId = null;
    protected static final String[] noRuleIds = new String[0];

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.desc;
    }

    public Image getImage() {
        if (this.contributorId != null && this.imgKey != null) {
            ImageDescriptor imgDesc = AbstractUIPlugin.imageDescriptorFromPlugin((String)this.contributorId, (String)this.imgKey);
            return imgDesc.createImage();
        }
        return null;
    }

    public final void setLabel(String label) {
        this.label = label;
    }

    public final void setDescription(String desc) {
        this.desc = desc;
    }

    public final void setImgKey(String key) {
        this.imgKey = key;
    }

    public final void setContributorId(String id) {
        this.contributorId = id;
    }

    public final String getContributorId() {
        return this.contributorId;
    }

    public List<EObject> getModelElements(IMarker marker) {
        return MarkerViewHelper.getModelElementsFromMarker((IMarker)marker);
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        if (markers.length == 1 && this.canResolve(markers[0])) {
            return new IMarker[]{markers[0]};
        }
        ArrayList<IMarker> otherMarkers = new ArrayList<IMarker>();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (this.canResolve(marker)) {
                otherMarkers.add(marker);
            }
            ++n2;
        }
        return otherMarkers.toArray(new IMarker[0]);
    }

    protected boolean canResolve(IMarker marker) {
        String ruleId = MarkerViewHelper.getRuleID((IMarker)marker, (boolean)true);
        if (ruleId != null) {
            String shortRuleId;
            if (this.isEMFRule(ruleId)) {
                return true;
            }
            String[] fqnRule = ruleId.split("\\.");
            String string = shortRuleId = fqnRule.length > 0 ? fqnRule[fqnRule.length - 1] : null;
            if (shortRuleId != null) {
                String[] stringArray = this.getResolvableRuleIds();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    if (shortRuleId.equals(id)) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    private boolean isEMFRule(String ruleId) {
        return ruleId.startsWith("org.eclipse.emf.ecore.");
    }

    protected String[] getResolvableRuleIds() {
        Map<AbstractCapellaMarkerResolution, Set<String>> resolverRuleMap = MarkerResolutionCache.INSTANCE.getResolverRuleMap();
        Set<String> ruleIds = resolverRuleMap.get((Object)this);
        if (ruleIds == null) {
            return noRuleIds;
        }
        return ruleIds.toArray(new String[0]);
    }

    public boolean isMultipleMarkersResolver() {
        return this.getResolvableRuleIds().length != noRuleIds.length;
    }

    protected void deleteMarker(IMarker marker) {
        try {
            marker.delete();
        }
        catch (CoreException exception) {
            StatusManager.getManager().handle((IStatus)new Status(4, PluginActivator.getDefault().getPluginId(), exception.getMessage(), (Throwable)exception));
        }
    }
}

