/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.accelerators;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.ui.actions.ModelAdaptation;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementLink;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.model.helpers.FunctionalChainExt;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;

public class AcceleratorOnFCILinkHandler
extends AbstractHandler {
    public Object execute(final ExecutionEvent event) throws ExecutionException {
        ExecutionManager manager;
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        final List<FunctionalChainInvolvementLink> fciLinks = this.getFCILinksFromSelection(selection);
        if (!fciLinks.isEmpty() && (manager = TransactionHelper.getExecutionManager(fciLinks)) != null) {
            manager.execute((ICommand)new AbstractReadWriteCommand(){

                public void run() {
                    fciLinks.stream().forEach(FunctionalChainExt::createSequenceLink);
                    IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
                    DiagramServices.getDiagramServices().refreshRepresentationOfEditor(activeEditor);
                }
            });
        }
        return null;
    }

    private List<FunctionalChainInvolvementLink> getFCILinksFromSelection(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            Throwable throwable = null;
            Object var4_5 = null;
            try (Stream<Object> stream = Stream.of(structuredSelection.toArray());){
                return stream.map(ModelAdaptation::adaptToCapella).filter(FunctionalChainInvolvementLink.class::isInstance).map(FunctionalChainInvolvementLink.class::cast).filter(link -> link.getInvolved() instanceof FunctionalExchange).collect(Collectors.toList());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return Collections.emptyList();
    }

    public boolean isEnabled() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        ISelection selection = activePage.getSelection();
        return !this.getFCILinksFromSelection(selection).isEmpty();
    }
}

