/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.actions.extensions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.sirius.analysis.StateMachineServices;
import org.polarsys.capella.core.sirius.analysis.actions.extensions.AbstractExternalJavaAction;

public class ShowHideStates
extends AbstractExternalJavaAction {
    public static final String ELEMENT_VIEW = "view";
    public static final String SELECTED_STATES = "selected states";
    public static final String VISIBLE_STATES = "visible states";
    public static final String VISIBLE_STATE_VIEWS = "visible state views";

    public void execute(Collection<? extends EObject> selections, Map<String, Object> parameters) {
        DSemanticDecorator view = (DSemanticDecorator)parameters.get(ELEMENT_VIEW);
        ArrayList<State> selectedStates = (ArrayList<State>)parameters.get(SELECTED_STATES);
        ArrayList<State> visibleStates = (ArrayList<State>)parameters.get(VISIBLE_STATES);
        ArrayList<AbstractDNode> visibleStateViews = (ArrayList<AbstractDNode>)parameters.get(VISIBLE_STATE_VIEWS);
        if (selectedStates == null) {
            selectedStates = new ArrayList<State>();
        }
        if (visibleStates == null) {
            visibleStates = new ArrayList<State>();
        }
        if (visibleStateViews == null) {
            visibleStateViews = new ArrayList<AbstractDNode>();
        }
        StateMachineServices.getService().showHideStatesInStateAndModeDiag(view, selectedStates, visibleStates, visibleStateViews);
    }
}

