/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.cache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.swt.graphics.Image;
import org.polarsys.capella.core.sirius.analysis.cache.PieIconCache;

public class DEdgeIconCache {
    private static DEdgeIconCache instance;
    private Map<DEdge, Image> edge2Icon = new HashMap<DEdge, Image>();
    private Map<DEdge, String> edge2Label = new HashMap<DEdge, String>();

    public static DEdgeIconCache getInstance() {
        if (instance == null) {
            instance = new DEdgeIconCache();
        }
        return instance;
    }

    private DEdgeIconCache() {
    }

    public Image setIcon(DEdge plEdge, List<RGBValues> colors) {
        return this.edge2Icon.computeIfAbsent(plEdge, k -> PieIconCache.getInstance().getIcon(colors));
    }

    public Image getIcon(DEdge plEdge) {
        return this.edge2Icon.get(plEdge);
    }

    public String setLabel(DEdge plEdge, String label) {
        return this.edge2Label.computeIfAbsent(plEdge, k -> label);
    }

    public String getLabel(DEdge plEdge) {
        return this.edge2Label.get(plEdge);
    }

    public void reset() {
        this.edge2Icon.clear();
        this.edge2Label.clear();
    }

    public void removeIcon(DEdge dEdge) {
        this.edge2Icon.remove(dEdge);
    }

    public void removeLabel(DEdge dEdge) {
        this.edge2Label.remove(dEdge);
    }
}

