/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.cache;

import java.util.HashMap;
import java.util.Map;
import org.polarsys.capella.core.data.cs.PhysicalPath;
import org.polarsys.capella.core.model.helpers.graph.PhysicalPathInternalLinksGraph;
import org.polarsys.capella.core.model.helpers.graph.PhysicalPathInvolvementGraph;

public class PhysicalPathCache {
    private static PhysicalPathCache instance;
    private Map<PhysicalPath, PhysicalPathInvolvementGraph> involvementGraphs = new HashMap<PhysicalPath, PhysicalPathInvolvementGraph>();
    private Map<PhysicalPathInvolvementGraph, PhysicalPathInternalLinksGraph> internalLinksGraphs = new HashMap<PhysicalPathInvolvementGraph, PhysicalPathInternalLinksGraph>();

    public static PhysicalPathCache getInstance() {
        if (instance == null) {
            instance = new PhysicalPathCache();
        }
        return instance;
    }

    private PhysicalPathCache() {
    }

    public PhysicalPathInvolvementGraph getInvolvementGraph(PhysicalPath path) {
        return this.involvementGraphs.computeIfAbsent(path, PhysicalPathInvolvementGraph::new);
    }

    public PhysicalPathInternalLinksGraph getInternalLinksGraph(PhysicalPathInvolvementGraph graph) {
        return this.internalLinksGraphs.computeIfAbsent(graph, PhysicalPathInternalLinksGraph::new);
    }

    public void reset() {
        this.involvementGraphs.clear();
        this.internalLinksGraphs.clear();
    }
}

