/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.delete;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.delete.IDeleteHook;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.diagram.helpers.TitleBlockHelper;
import org.polarsys.capella.core.model.preferences.IDeletePreferences;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;

public class CapellaDeleteActionHook
implements IDeleteHook {
    private static Collection<EObject> selection;

    public static Collection<EObject> getSelection() {
        return selection;
    }

    protected static void setSelection(Collection<EObject> semanticElements) {
        selection = semanticElements;
    }

    public static void removeSelection() {
        CapellaDeleteActionHook.setSelection(null);
    }

    public IStatus beforeDeleteCommandExecution(Collection<DSemanticDecorator> selection, Map<String, Object> parameters) {
        if (selection == null || selection.isEmpty()) {
            return Status.CANCEL_STATUS;
        }
        Collection<EObject> deletionCandidates = this.extractDeletionCandidates(selection);
        CapellaDeleteActionHook.setSelection(deletionCandidates);
        if (this.confirmDeletion(deletionCandidates)) {
            return Status.OK_STATUS;
        }
        CapellaDeleteActionHook.removeSelection();
        return Status.CANCEL_STATUS;
    }

    private Collection<EObject> extractDeletionCandidates(Collection<DSemanticDecorator> selection) {
        HashSet<EObject> semanticElements = new HashSet<EObject>(selection.size());
        for (DSemanticDecorator semanticDecorator : selection) {
            EObject target = semanticDecorator.getTarget();
            if (target == null) continue;
            if (!(target instanceof DAnnotation) && semanticDecorator instanceof DDiagramElement) {
                DDiagramElement diagramElement = (DDiagramElement)semanticDecorator;
                RepresentationElementMapping mapping = diagramElement.getMapping();
                if (TitleBlockHelper.isTitleBlockMapping((RepresentationElementMapping)mapping)) continue;
                semanticElements.add(target);
                continue;
            }
            semanticElements.add(target);
        }
        return semanticElements;
    }

    private boolean confirmDeletion(Collection<EObject> deletionCandidates) {
        if (IDeletePreferences.INSTANCE.isConfirmationRequired()) {
            ExecutionManager executionManager = TransactionHelper.getExecutionManager(deletionCandidates);
            return executionManager != null && CapellaDeleteCommand.confirmDeletion((ExecutionManager)executionManager, deletionCandidates);
        }
        return true;
    }
}

