/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.refresh.extension;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.data.helpers.modellingcore.utils.HoldingResourceFilter;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.refresh.extension.Messages;

public abstract class AbstractRefreshExtension {
    protected boolean isLinkedToUselessTarget(DSemanticDecorator element) {
        EObject target = element.getTarget();
        return target == null || target.eResource() == null || HoldingResourceFilter.getInstance().isHoldByHoldingResource(target);
    }

    protected List<AbstractNodeMapping> getListOfMappingsToMove(DDiagram diagram) {
        return Collections.emptyList();
    }

    protected boolean isVisibleInDiagram(DDiagramElement anElement) {
        return anElement.isVisible();
    }

    protected void reorderElements(DDiagram diagram) {
        this.reorderElements(new DDiagramContents(diagram));
    }

    protected void reorderElements(DDiagramContents diagramContent) {
        try {
            DDiagram diagram = diagramContent.getDDiagram();
            HashMap<DDiagramElement, DragAndDropTarget> toBeMoved = new HashMap<DDiagramElement, DragAndDropTarget>();
            List<AbstractNodeMapping> mappingsToMove = this.getListOfMappingsToMove(diagram);
            for (DDiagramElement dDiagramElement : diagramContent.getDiagramElements()) {
                DragAndDropTarget bestContainer;
                if (!mappingsToMove.contains(dDiagramElement.getDiagramElementMapping()) || !this.isReorderable(dDiagramElement) || this.isWellContained(dDiagramElement, (EObject)(bestContainer = diagramContent.getBestContainer(dDiagramElement)))) continue;
                toBeMoved.put(dDiagramElement, bestContainer);
            }
            for (Map.Entry entry : toBeMoved.entrySet()) {
                DDiagramElement key = (DDiagramElement)entry.getKey();
                DragAndDropTarget target = (DragAndDropTarget)entry.getValue();
                EList<DDiagramElement> ownedElements = DiagramServices.getDiagramServices().getOwnedDiagramElements(target);
                if (ownedElements == null || ownedElements.contains((Object)key)) continue;
                ownedElements.add((Object)key);
            }
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnReordering, (Throwable)e);
        }
    }

    protected boolean isWellContained(DDiagramElement anElement, EObject bestContainer) {
        return bestContainer.equals(anElement.eContainer());
    }

    protected boolean isReorderable(DDiagramElement element) {
        return element != null && (!(element instanceof AbstractDNode) || !DiagramServices.getDiagramServices().isABorderedNode((AbstractDNode)element)) && !this.isLinkedToUselessTarget((DSemanticDecorator)element) && this.isVisibleInDiagram(element);
    }
}

