/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.showhide;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeCategory;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.sirius.analysis.ABServices;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.constants.MappingConstantsHelper;
import org.polarsys.capella.core.sirius.analysis.showhide.AbstractShowHide;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideABComponentExchange;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;

public class ShowHideABComponentCategory
extends ShowHideABComponentExchange {
    public static final String NO_SOURCE_PORT = "npo";
    public static final String NO_TARGET_PORT = "npo";
    public static final String SOURCE_PORTS = "spo";
    public static final String TARGET_PORTS = "tpo";

    public ShowHideABComponentCategory(DDiagramContents content_p) {
        super(content_p);
    }

    @Override
    public HashMapSet<String, EObject> getRelatedObjects(EObject semantic_p, AbstractShowHide.DiagramContext context_p) {
        HashMapSet<String, EObject> value = super.getRelatedObjects(semantic_p, context_p);
        AbstractShowHide.ContextItemElement lastContext = context_p.getLast();
        if (lastContext.getValue() instanceof ComponentExchangeCategory) {
            if ("source".equals(lastContext.getKey())) {
                AbstractShowHide.ContextItemVariable variable = context_p.getLastVariable("sourceParts");
                if (variable != null && variable.getValue() instanceof Collection) {
                    value.putAll("container", (Collection)variable.getValue());
                }
            } else if ("target".equals(lastContext.getKey())) {
                AbstractShowHide.ContextItemVariable variable = context_p.getLastVariable("targetParts");
                if (variable != null && variable.getValue() instanceof Collection) {
                    value.putAll("container", (Collection)variable.getValue());
                }
            } else {
                AbstractShowHide.ContextItemVariable noSourcePort = context_p.getLastVariable("npo");
                AbstractShowHide.ContextItemVariable noTargetPort = context_p.getLastVariable("npo");
                AbstractShowHide.ContextItemVariable variable = context_p.getLastVariable(SOURCE_PORTS);
                if (variable != null && variable.getValue() instanceof Collection) {
                    value.putAll("source", (Collection)variable.getValue());
                } else if (noSourcePort == null || Boolean.FALSE.equals(noSourcePort.getValue())) {
                    value.put("source", semantic_p);
                } else {
                    variable = context_p.getLastVariable("sourceParts");
                    if (variable != null && variable.getValue() instanceof Collection) {
                        value.putAll("source", (Collection)variable.getValue());
                    }
                }
                variable = context_p.getLastVariable(TARGET_PORTS);
                if (variable != null && variable.getValue() instanceof Collection) {
                    value.putAll("target", (Collection)variable.getValue());
                } else if (noTargetPort == null || Boolean.FALSE.equals(noTargetPort.getValue())) {
                    value.put("target", semantic_p);
                } else {
                    variable = context_p.getLastVariable("targetParts");
                    if (variable != null && variable.getValue() instanceof Collection) {
                        value.putAll("target", (Collection)variable.getValue());
                    }
                }
            }
        }
        return value;
    }

    @Override
    public DiagramElementMapping getMapping(EObject semantic_p, AbstractShowHide.DiagramContext context_p, HashMapSet<String, DSemanticDecorator> relatedViews_p) {
        DiagramElementMapping mapping = super.getMapping(semantic_p, context_p, relatedViews_p);
        AbstractShowHide.ContextItemElement lastContext = context_p.getLast();
        if (lastContext.getValue() instanceof ComponentExchangeCategory) {
            mapping = "source".equals(lastContext.getKey()) ? this.getContent().getMapping(MappingConstantsHelper.getMappingABComponentCategoryPin(this.getContent().getDDiagram())) : ("target".equals(lastContext.getKey()) ? this.getContent().getMapping(MappingConstantsHelper.getMappingABComponentCategoryPin(this.getContent().getDDiagram())) : this.getContent().getMapping(MappingConstantsHelper.getMappingABComponentCategory(this.getContent().getDDiagram())));
        }
        return mapping;
    }

    @Override
    protected boolean isValidEdgeView(DEdge edge_p, DSemanticDecorator sourceView_p, DSemanticDecorator targetView_p) {
        DiagramElementMapping categoryMapping = this.getContent().getMapping(MappingConstantsHelper.getMappingABComponentCategory(this.getContent().getDDiagram()));
        if (categoryMapping.equals(edge_p.getActualMapping()) && sourceView_p.equals(edge_p.getTargetNode()) && targetView_p.equals(edge_p.getSourceNode())) {
            return true;
        }
        return super.isValidEdgeView(edge_p, sourceView_p, targetView_p);
    }

    @Override
    protected Collection<DSemanticDecorator> retrieveDefaultContainer(EObject semantic_p, AbstractShowHide.DiagramContext context_p, Collection<DSemanticDecorator> targetViews_p) {
        return super.retrieveDefaultContainer(semantic_p, context_p, targetViews_p);
    }

    @Override
    protected boolean mustShow(AbstractShowHide.ContextItemElement originCouple_p, AbstractShowHide.DiagramContext context_p, HashMapSet<String, DSemanticDecorator> relatedViews_p) {
        EObject semantic = originCouple_p.getValue();
        if (semantic instanceof Part || semantic instanceof Entity) {
            for (AbstractShowHide.ContextItemView view : originCouple_p.getViews()) {
                if (view.getViews().get("views").size() <= 0) continue;
                return false;
            }
            return false;
        }
        if (semantic instanceof ComponentExchangeCategory) {
            return true;
        }
        return super.mustShow(originCouple_p, context_p, relatedViews_p);
    }

    @Override
    protected boolean mustShow(DSemanticDecorator source_p, DSemanticDecorator target_p, EObject exchange_p, EdgeMapping edgeMapping_p) {
        if (exchange_p instanceof ComponentExchangeCategory) {
            return ABServices.getService().isValidABComponentCategoryEdge((ComponentExchangeCategory)exchange_p, source_p, target_p);
        }
        return super.mustShow(source_p, target_p, exchange_p, edgeMapping_p);
    }

    @Override
    protected boolean mustHide(AbstractShowHide.ContextItemElement originCouple_p, AbstractShowHide.DiagramContext context_p) {
        EObject semantic = originCouple_p.getValue();
        if (semantic instanceof ComponentExchangeCategory) {
            return true;
        }
        return super.mustHide(originCouple_p, context_p);
    }

    @Override
    protected boolean hideInsteadOfRemoveView(DDiagramElement element_p, AbstractShowHide.DiagramContext context_p) {
        EObject target = element_p.getTarget();
        if (target instanceof ComponentPort) {
            return this.getContent().getDDiagram().isSynchronized();
        }
        return super.hideInsteadOfRemoveView(element_p, context_p);
    }

    @Override
    protected boolean mustHide(DDiagramElement view_p, AbstractShowHide.DiagramContext context_p) {
        ComponentExchange ce;
        EObject target;
        if (view_p.getDiagramElementMapping() instanceof AbstractNodeMapping && (target = view_p.getTarget()) != null && target instanceof ComponentPort) {
            boolean result = true;
            if (result) {
                for (DEdge edge : ((EdgeTarget)view_p).getIncomingEdges()) {
                    if (!this.getContent().isVisible((DDiagramElement)edge)) continue;
                    result = false;
                    break;
                }
            }
            if (result) {
                for (DEdge edge : ((EdgeTarget)view_p).getOutgoingEdges()) {
                    if (!this.getContent().isVisible((DDiagramElement)edge)) continue;
                    result = false;
                    break;
                }
            }
            return result;
        }
        if (view_p.getTarget() instanceof ComponentExchange && view_p instanceof DEdge && this.isDelegation(ce = (ComponentExchange)view_p.getTarget())) {
            EObject targetTarget;
            EObject sourceTarget;
            EdgeTarget source = this.getSourceDelegationView((DEdge)view_p, ce);
            boolean result = true;
            if (result) {
                for (DEdge edge : source.getIncomingEdges()) {
                    if (!(edge.getTarget() instanceof ComponentExchangeCategory)) continue;
                    sourceTarget = ((DSemanticDecorator)edge.getSourceNode()).getTarget();
                    targetTarget = ((DSemanticDecorator)edge.getTargetNode()).getTarget();
                    if (sourceTarget instanceof ComponentExchangeCategory && targetTarget instanceof ComponentPort) {
                        result = false;
                    }
                    if (!(targetTarget instanceof ComponentExchangeCategory) || !(sourceTarget instanceof ComponentPort)) continue;
                    result = false;
                }
            }
            if (result) {
                for (DEdge edge : source.getOutgoingEdges()) {
                    if (!(edge.getTarget() instanceof ComponentExchangeCategory)) continue;
                    sourceTarget = ((DSemanticDecorator)edge.getSourceNode()).getTarget();
                    targetTarget = ((DSemanticDecorator)edge.getTargetNode()).getTarget();
                    if (sourceTarget instanceof ComponentExchangeCategory && targetTarget instanceof ComponentPort) {
                        result = false;
                    }
                    if (!(targetTarget instanceof ComponentExchangeCategory) || !(sourceTarget instanceof ComponentPort)) continue;
                    result = false;
                }
            }
            if (!result) {
                return result;
            }
        }
        return super.mustHide(view_p, context_p);
    }

    protected EdgeTarget getSourceDelegationView(DEdge view_p, ComponentExchange link_p) {
        EdgeTarget result = view_p.getSourceNode();
        return result;
    }

    protected boolean isDelegation(ComponentExchange ce_p) {
        return ComponentExchangeExt.isDelegation((ComponentExchange)ce_p);
    }

    @Override
    protected Collection<DDiagramElement> showNodes(DSemanticDecorator containerView_p, EObject semantic_p, DDiagramContents content_p, AbstractNodeMapping mapping_p) {
        Collection<DDiagramElement> nodes = super.showNodes(containerView_p, semantic_p, content_p, mapping_p);
        if (semantic_p instanceof ComponentPort) {
            for (DDiagramElement element : nodes) {
                this.getContent().deferredShow(element);
            }
        }
        return nodes;
    }

    @Override
    protected Collection<DDiagramElement> showEdges(DSemanticDecorator source_p, DSemanticDecorator target_p, EObject exchange_p, DDiagramContents content_p, EdgeMapping edgeMapping_p) {
        Collection<DDiagramElement> nodes = super.showEdges(source_p, target_p, exchange_p, content_p, edgeMapping_p);
        if (exchange_p instanceof ComponentExchange) {
            for (DDiagramElement element : nodes) {
                this.getContent().deferredShow(element);
            }
        }
        return nodes;
    }
}

