/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.communication;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.core.data.helpers.information.services.LinkCompatibilityDefinition;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkKind;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkProtocol;
import org.polarsys.capella.core.model.utils.ListExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class CommunicationLinkProtocolRule
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof CommunicationLink) {
            CommunicationLinkKind expectedKind;
            ArrayList<IStatus> statuses = new ArrayList<IStatus>();
            CommunicationLink link = (CommunicationLink)eObj;
            CommunicationLinkProtocol protocol = link.getProtocol();
            CommunicationLinkKind kind = link.getKind();
            if (protocol != null && kind != null && protocol != CommunicationLinkProtocol.UNSET && kind != (expectedKind = LinkCompatibilityDefinition.INSTANCE.getKind(protocol))) {
                Collection expectedProtocols = LinkCompatibilityDefinition.INSTANCE.getCompatibleProtocols(kind);
                String expectedProtocol = ListExt.toString((Collection)expectedProtocols, (String)" || ");
                IStatus status = ctx.createFailureStatus(new Object[]{link, kind, expectedProtocol});
                statuses.add(status);
            }
            if (statuses.size() > 0) {
                return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
            }
        }
        return ctx.createSuccessStatus();
    }
}

