/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.metric.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.capella.core.ui.metric.MetricActivator;
import org.polarsys.capella.core.ui.metric.MetricMessages;
import org.polarsys.capella.core.ui.metric.actions.ProgressMonitoringActionsHelper;
import org.polarsys.capella.core.ui.metric.actions.ProgressSetDialog;
import org.polarsys.capella.core.ui.metric.utils.ProgressMonitoringPropagator;

public class ProgressMonitoringSetAction
extends BaseSelectionListenerAction {
    private static final Logger logger = ReportManagerRegistry.getInstance().subscribe("Progress Monitoring");
    private static final String strStatus = "Status";
    private static final String strReview = "Review";

    public ProgressMonitoringSetAction() {
        super(MetricMessages.progressMonitoring_setAction_lbl);
        this.setImageDescriptor(MetricActivator.getDefault().getImageDescriptor("progress_16.gif"));
    }

    private int getNbElementsOfType(Collection<EObject> inCollection, Class clazz) {
        int nb = 0;
        for (EObject eo : inCollection) {
            if (!clazz.isInstance(eo)) continue;
            ++nb;
        }
        return nb;
    }

    public void run() {
        final Collection<EObject> selectedObjects = ProgressMonitoringActionsHelper.getSelectedEObjects(this.getStructuredSelection());
        if (selectedObjects.isEmpty()) {
            return;
        }
        final ProgressSetDialog dialog = this.getRunSetup(selectedObjects);
        if (dialog != null) {
            TransactionHelper.getExecutionManager((EObject)selectedObjects.iterator().next()).execute((ICommand)new AbstractReadWriteCommand(){

                public void run() {
                    Object[] arguments;
                    ProgressSetDialog.PropagateChoice propagateChoice = dialog.getPropagateChoiceWithoutFiltering();
                    boolean semanticElementPropagation = propagateChoice == ProgressSetDialog.PropagateChoice.ONLY_BUSINESS_ELEMENTS || propagateChoice == ProgressSetDialog.PropagateChoice.ALL_CAPELLA_ELEMENTS;
                    boolean technicalElementPropagation = propagateChoice == ProgressSetDialog.PropagateChoice.ALL_CAPELLA_ELEMENTS;
                    List result = ProgressMonitoringPropagator.getInstance().applyPropertiesOn(Collections.singletonList(dialog.getSelectedEnum()), selectedObjects, semanticElementPropagation, technicalElementPropagation, dialog.isPropagateToRepresentations(), dialog.useFilterStatus(), this.getLabel(dialog), dialog.mustCleanReview(), dialog.mustPropagateStatus());
                    int nbCapellaElementTagged = ProgressMonitoringSetAction.this.getNbElementsOfType((Collection)result.get(0), CapellaElement.class);
                    int nbDRepresentationTagged = ProgressMonitoringSetAction.this.getNbElementsOfType((Collection)result.get(0), DRepresentationDescriptor.class);
                    int nbCapellaElementReviewedCleared = ProgressMonitoringSetAction.this.getNbElementsOfType((Collection)result.get(1), CapellaElement.class);
                    int nbDRepresentationReviewedCleared = ProgressMonitoringSetAction.this.getNbElementsOfType((Collection)result.get(1), DRepresentationDescriptor.class);
                    if (nbCapellaElementTagged + nbDRepresentationTagged == 0) {
                        logger.info((Object)NLS.bind((String)MetricMessages.progressMonitoring_setAction_nochanges_info, (Object)ProgressMonitoringSetAction.strStatus));
                    } else {
                        arguments = new String[]{ProgressMonitoringSetAction.strStatus, Integer.toString(nbCapellaElementTagged), Integer.toString(nbDRepresentationTagged)};
                        logger.info((Object)NLS.bind((String)MetricMessages.progressMonitoring_setAction_changes_info, (Object[])arguments));
                    }
                    if (nbCapellaElementReviewedCleared + nbDRepresentationReviewedCleared == 0) {
                        logger.info((Object)NLS.bind((String)MetricMessages.progressMonitoring_setAction_nochanges_info, (Object)ProgressMonitoringSetAction.strReview));
                    } else {
                        arguments = new String[]{ProgressMonitoringSetAction.strReview, Integer.toString(nbCapellaElementReviewedCleared), Integer.toString(nbDRepresentationReviewedCleared)};
                        logger.info((Object)NLS.bind((String)MetricMessages.progressMonitoring_setAction_nochanges_info, (Object[])arguments));
                    }
                }

                private String getLabel(ProgressSetDialog runSetup) {
                    return runSetup.getFilterStatus() == null ? null : runSetup.getFilterStatus().getLabel();
                }

                public String getName() {
                    return MetricMessages.progressMonitoring_setAction_cmd_lbl;
                }
            });
        }
    }

    protected ProgressSetDialog getRunSetup(Collection<EObject> selectedObjects) {
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        ProgressSetDialog dialog = new ProgressSetDialog(shell, selectedObjects);
        if (dialog.open() == 0) {
            return dialog;
        }
        return null;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (selection != null) {
            boolean enabled = true;
            HashSet<IProject> projects = new HashSet<IProject>();
            for (Object object : selection) {
                enabled &= this.isEnabled(object);
                projects.add(this.getProject(object));
            }
            return enabled && projects.size() == 1;
        }
        return false;
    }

    private IProject getProject(Object object) {
        if (object instanceof EObject) {
            return this.getProject(EcoreUtil2.getFile((Resource)((EObject)object).eResource()));
        }
        if (object instanceof IFile) {
            return ((IFile)object).getProject();
        }
        return null;
    }

    private boolean isEnabled(Object selection) {
        if (selection instanceof IFile) {
            Session session = SessionHelper.getSession((IFile)((IFile)selection));
            if (session != null && session.isOpen()) {
                Resource resource = session.getSessionResource();
                DAnalysis da = (DAnalysis)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)ViewpointPackage.Literals.DANALYSIS);
                ArrayList models = new ArrayList();
                if (da != null) {
                    models.addAll(da.getModels());
                    for (DAnalysis refDa : da.getReferencedAnalysis()) {
                        models.addAll(refDa.getModels());
                    }
                }
                boolean showProgressAction = false;
                for (EObject model : models) {
                    boolean bl = showProgressAction = showProgressAction || ProgressMonitoringPropagator.getInstance().isEnumerationPropertyTypeDefinedForProject(model);
                }
                return showProgressAction;
            }
        } else if (selection instanceof EObject) {
            return ProgressMonitoringPropagator.getInstance().isEnumerationPropertyTypeDefinedForProject((EObject)selection);
        }
        return false;
    }
}

