/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.queries.debug;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import org.polarsys.capella.common.queries.debug.DefaultPrinter;
import org.polarsys.capella.common.queries.debug.ObjectPrinter;

public class LoggerHelpers {
    public static DefaultPrinter<? extends Object> defaultPrinter = new DefaultPrinter();

    public static <X> String printCollection(Collection<X> collection, ObjectPrinter<X> printer) {
        StringBuffer buffer = new StringBuffer();
        Iterator<X> it = collection.iterator();
        while (it.hasNext()) {
            buffer.append(printer.print(it.next()));
            if (!it.hasNext()) continue;
            buffer.append('\n');
        }
        return buffer.toString();
    }

    public static <X, Y> String printHashTable(Hashtable<X, Y> table, ObjectPrinter<X> keyPrinter, ObjectPrinter<Y> valuePrinter) {
        int maxKeyStringLentgh = 0;
        ArrayList<String> keysStrings = new ArrayList<String>();
        ArrayList<String> valueStrings = new ArrayList<String>();
        for (X key : table.keySet()) {
            String keyString = null;
            keyString = keyPrinter != null ? keyPrinter.print(key) : key.toString();
            keysStrings.add(keyString);
            int keyStringLength = keyString.length();
            if (maxKeyStringLentgh < keyStringLength) {
                maxKeyStringLentgh = keyStringLength;
            }
            Y value = table.get(key);
            String valueString = null;
            valueString = valuePrinter != null ? valuePrinter.print(value) : value.toString();
            valueStrings.add(valueString);
        }
        StringBuffer buffer = new StringBuffer();
        int keysStringsSize = keysStrings.size();
        int i = 0;
        while (i < keysStringsSize) {
            String keyString = (String)keysStrings.get(i);
            buffer.append(LoggerHelpers.normalizeStringLength(keyString, maxKeyStringLentgh));
            buffer.append(" : ");
            buffer.append((String)valueStrings.get(i));
            if (i < keysStringsSize - 1) {
                buffer.append('\n');
            }
            ++i;
        }
        return buffer.toString();
    }

    private static String normalizeStringLength(String value, int length) {
        StringBuffer b = new StringBuffer();
        b.append(value);
        int i = b.length();
        while (i < length) {
            b.append(' ');
            ++i;
        }
        return b.toString();
    }
}

