/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.queries.debug;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.queries.filters.IQueryFilter;
import org.polarsys.capella.common.queries.interpretor.QueryInterpretor;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.common.queries.queryContext.QueryContext;
import org.polarsys.capella.common.queries.testGeneration.QueryTester;

public class QueryDebugger {
    public static List<?> executeQueryWithInclusionDebug(String queryIdentifier, Object semanticsObject, Collection<?> oldResult) {
        return QueryDebugger.executeQueryWithInclusionDebug(queryIdentifier, semanticsObject, new QueryContext(), null, oldResult);
    }

    public static List<?> executeQueryWithInclusionDebug(String queryIdentifier, Object semanticsObject, QueryContext context, Collection<?> oldResult) {
        return QueryDebugger.executeQueryWithInclusionDebug(queryIdentifier, semanticsObject, context, null, oldResult);
    }

    public static List<?> executeQueryWithInclusionDebug(String queryIdentifier, Object semanticsObject, IQueryFilter filter, Collection<?> oldResult) {
        return QueryDebugger.executeQueryWithInclusionDebug(queryIdentifier, semanticsObject, new QueryContext(), filter, oldResult);
    }

    public static List<?> executeQueryWithEqualityDebug(String queryIdentifier, Object semanticsObject, Collection<?> oldResult) {
        return QueryDebugger.executeQueryWithEqualityDebug(queryIdentifier, semanticsObject, new QueryContext(), oldResult);
    }

    public static List<?> executeQueryWithInclusionDebug(String queryIdentifier, Object semanticsObject, QueryContext context, IQueryFilter filter, Collection<?> oldResult) {
        List<Object> result = null;
        try {
            result = QueryInterpretor.executeQuery(queryIdentifier, semanticsObject, (IQueryContext)context, filter);
            QueryDebugger.storeTestData(queryIdentifier, semanticsObject, result);
            if (!QueryDebugger.assertSetIncludedInSet(oldResult, result)) {
                Logger.getLogger((String)"Model Management").debug((Object)("assertSetIncludedInSet failed for query " + queryIdentifier), null);
                System.out.println("!! ORACLE COMPARISON FAILED !!");
                System.out.println("assertSetIncludedInSet failed for query " + queryIdentifier);
            }
        }
        catch (Exception exception) {
            Logger.getLogger((String)"Model Management").debug((Object)("BUG DURING QUERY CALL !!" + queryIdentifier), (Throwable)exception);
            System.out.println("!! BUG DURING QUERY CALL !!");
            exception.printStackTrace();
        }
        return result;
    }

    public static List<?> executeQueryWithEqualityDebug(String queryIdentifier, Object semanticsObject, QueryContext context, Collection<?> oldResult) {
        List<Object> result = null;
        try {
            result = QueryInterpretor.executeQuery(queryIdentifier, semanticsObject, context);
            QueryDebugger.storeTestData(queryIdentifier, semanticsObject, result);
            if (!QueryDebugger.assertSetEqualToSet(oldResult, result)) {
                Logger.getLogger((String)"Model Management").debug((Object)("assertSetEqualToSet failed for query " + queryIdentifier), null);
                System.out.println("!! ORACLE COMPARISON FAILED !!");
                System.out.println("assertSetEqualToSet failed for query " + queryIdentifier);
                System.out.println("old result :");
                for (Object obj : oldResult) {
                    System.out.println("  " + String.valueOf(obj));
                }
                System.out.println("new result :");
                for (Object object : result) {
                    System.out.println("  " + String.valueOf(object));
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger((String)"Model Management").debug((Object)("BUG DURING QUERY CALL !!" + queryIdentifier), (Throwable)exception);
            System.out.println("!! BUG DURING QUERY CALL !!");
            exception.printStackTrace();
        }
        return result;
    }

    private static boolean assertSetIncludedInSet(Collection<?> set1, Collection<?> set2) {
        for (Object object : set1) {
            if (set2.contains(object)) continue;
            return false;
        }
        return true;
    }

    private static boolean assertSetEqualToSet(Collection<?> set1, Collection<?> set2) {
        return set1.size() == set2.size() && QueryDebugger.assertSetIncludedInSet(set1, set2);
    }

    private static void storeTestData(String queryIdentifier, Object semanticsObject, List<Object> objects) {
        EObject input;
        IProject eclipseProject;
        QueryTester testGenerator = QueryTester.generator;
        if (testGenerator != null && testGenerator.isEnabled() && semanticsObject instanceof EObject && (eclipseProject = QueryDebugger.getEclipseProjectFromEObject(input = (EObject)semanticsObject)) != null) {
            try {
                testGenerator.storeOracle(queryIdentifier, semanticsObject, objects, eclipseProject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static IProject getEclipseProjectFromEObject(EObject object) {
        try {
            String[] tab = StringUtils.split((String)object.eResource().getURI().toString(), (char)'/');
            String projectName = tab[2];
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            return root.getProject(projectName);
        }
        catch (Exception e) {
            return null;
        }
    }
}

