/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration.aird;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.internal.image.ImageDependenciesAnnotationHelper;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.polarsys.capella.core.data.migration.MigrationRunnable;
import org.polarsys.capella.core.data.migration.aird.AirdMigrationContributor;
import org.polarsys.capella.core.data.migration.aird.AirdMigrationRunnable;
import org.polarsys.capella.core.data.migration.aird.Messages;
import org.polarsys.capella.core.data.migration.context.MigrationContext;

public class ImageDependenciesMigrationContributor
extends AirdMigrationContributor {
    @Override
    public MigrationRunnable getRunnable(IFile file) {
        return new AirdMigrationRunnable(file){

            @Override
            public String getName() {
                return Messages.MigrationAction_ImageProjectDependencies;
            }

            @Override
            public IStatus run(MigrationContext context, boolean checkVersion) {
                IFile airdFile = this.getFile();
                URI airdURI = URI.createPlatformResourceURI((String)airdFile.getFullPath().toString(), (boolean)true);
                final Session session = SessionManager.INSTANCE.getSession(airdURI, (IProgressMonitor)new NullProgressMonitor());
                if (session != null) {
                    session.open((IProgressMonitor)new NullProgressMonitor());
                    session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(session.getTransactionalEditingDomain()){

                        protected void doExecute() {
                            new ImageDependenciesAnnotationHelper((DAnalysisSessionImpl)session).updateAllImageProjectsDependencies();
                        }
                    });
                    session.save((IProgressMonitor)new NullProgressMonitor());
                    session.close((IProgressMonitor)new NullProgressMonitor());
                }
                return Status.OK_STATUS;
            }
        };
    }

    @Override
    public String getKind() {
        return "MIGRATION_KIND__IMAGE_DEPENDENCIES";
    }
}

