/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties;

import java.util.Optional;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.polarsys.capella.common.ef.domain.IEditingDomainListener;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;
import org.polarsys.capella.common.model.IDelegatedListener;
import org.polarsys.capella.core.ui.properties.CapellaDataListenerForPropertySections;
import org.polarsys.kitalpha.emde.model.Element;

public class CapellalEditingDomainListenerForPropertySections
extends ResourceSetListenerImpl
implements IEditingDomainListener {
    private static CapellaDataListenerForPropertySections dataListenerForPropertySections;
    private NotificationFilter notificationFilter;
    private Optional<IDelegatedListener> delegatedListener;

    public boolean isPostcommitOnly() {
        return true;
    }

    public NotificationFilter getFilter() {
        if (this.notificationFilter == null) {
            this.notificationFilter = new NotificationFilter.Custom(){

                public boolean matches(Notification notification) {
                    Object notifier = notification.getNotifier();
                    if (!(notifier instanceof EObject)) {
                        return false;
                    }
                    if (!(notifier instanceof Element) && !(notifier instanceof DRepresentation)) {
                        return false;
                    }
                    if (notification.getEventType() != 1 && notification.getEventType() != 2) {
                        return false;
                    }
                    Optional<IDelegatedListener> listener = CapellalEditingDomainListenerForPropertySections.this.getDelegatedListener();
                    if (listener.isPresent()) {
                        return !listener.get().filterNotification(notification);
                    }
                    return true;
                }
            };
        }
        return this.notificationFilter;
    }

    private Optional<IDelegatedListener> getDelegatedListener() {
        if (this.delegatedListener == null) {
            IDelegatedListener listener = null;
            IConfigurationElement[] configurationElements = ExtensionPointHelper.getConfigurationElements((String)"org.polarsys.capella.common.model", (String)"DelegatedListener");
            if (configurationElements.length > 0) {
                IConfigurationElement configurationElement = configurationElements[0];
                listener = (IDelegatedListener)ExtensionPointHelper.createInstance((IConfigurationElement)configurationElement, (String)"class");
            }
            this.delegatedListener = Optional.ofNullable(listener);
        }
        return this.delegatedListener;
    }

    public void createdEditingDomain(EditingDomain editingDomain) {
        if (editingDomain instanceof TransactionalEditingDomain) {
            ((TransactionalEditingDomain)editingDomain).addResourceSetListener((ResourceSetListener)this);
        }
    }

    public void disposedEditingDomain(EditingDomain editingDomain) {
        if (editingDomain instanceof TransactionalEditingDomain) {
            ((TransactionalEditingDomain)editingDomain).removeResourceSetListener((ResourceSetListener)this);
        }
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        super.resourceSetChanged(event);
        CapellalEditingDomainListenerForPropertySections.getCapellaDataListenerForPropertySections().refresh();
    }

    public static CapellaDataListenerForPropertySections getCapellaDataListenerForPropertySections() {
        if (dataListenerForPropertySections == null) {
            dataListenerForPropertySections = new CapellaDataListenerForPropertySections();
        }
        return dataListenerForPropertySections;
    }
}

