/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.fields;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.core.ui.properties.CapellaUIPropertiesPlugin;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.viewers.IDelegatedViewer;

public abstract class AbstractStructuredRepresentationField
extends AbstractSemanticField
implements ISelectionChangedListener {
    protected EReference _referencedFeature;
    private String _label;
    protected IDelegatedViewer _delegatedViewer;
    private Button _deleteBtn;

    public AbstractStructuredRepresentationField(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory, EReference referencedFeature, String label, IDelegatedViewer delegatedViewer) {
        super(widgetFactory);
        this._referencedFeature = referencedFeature;
        this._label = label;
        this._delegatedViewer = delegatedViewer;
        this._delegatedViewer.addSelectionChangedListener(this);
        this.createActions(parent);
        this._delegatedViewer.createContainer(parent);
    }

    private void createActions(Composite parent) {
        CLabel label = this.widgetFactory.createCLabel(this._delegatedViewer.getViewerGroup(parent), this._label);
        label.setLayoutData((Object)new GridData(4, 16, true, false));
        this.createCustomActions(parent);
        this._deleteBtn = this.createTableButton(parent, CapellaUIPropertiesPlugin.getDefault().getImage("Delete_16x16.gif"), new Runnable(){

            @Override
            public void run() {
                AbstractStructuredRepresentationField.this.handleDelete();
            }
        });
        this._deleteBtn.setToolTipText("Remove selected elements");
        this._deleteBtn.setEnabled(false);
    }

    protected abstract void createCustomActions(Composite var1);

    protected Button createTableButton(Composite parent, Image image, final Runnable runnable) {
        Button tableButton = this.widgetFactory.createButton(this._delegatedViewer.getViewerGroup(parent), null, 8);
        tableButton.setImage(image);
        tableButton.setLayoutData((Object)new GridData(3, 16, false, false));
        tableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                runnable.run();
            }
        });
        return tableButton;
    }

    protected abstract void handleDelete();

    @Override
    public void loadData(EObject semanticElement) {
        this.loadData(semanticElement, this.semanticFeature);
    }

    @Override
    public void loadData(EObject semanticElement, EStructuralFeature semanticFeature) {
        super.loadData(semanticElement, semanticFeature);
        if (this._delegatedViewer != null) {
            this._delegatedViewer.setInput(this.getReferencedElementsByContainedOnes());
        }
    }

    protected List<EObject> getReferencedElementsByContainedOnes() {
        List containedElements = (List)this.semanticElement.eGet(this.semanticFeature);
        ArrayList<EObject> referencedElements = new ArrayList<EObject>(0);
        for (EObject containedElement : containedElements) {
            if (this._referencedFeature != null) {
                EObject target;
                if (!containedElement.eClass().getEAllReferences().contains((Object)this._referencedFeature) || (target = (EObject)containedElement.eGet((EStructuralFeature)this._referencedFeature)) == null) continue;
                referencedElements.add(target);
                continue;
            }
            referencedElements.add(containedElement);
        }
        return referencedElements;
    }

    protected List<EObject> getContainedElementsfor(List<EObject> referencedElements) {
        ArrayList<EObject> result = new ArrayList<EObject>(0);
        for (EObject containedElement : (List)this.semanticElement.eGet(this.semanticFeature)) {
            EObject referencedObject;
            EObject eObject = referencedObject = this._referencedFeature != null ? (EObject)containedElement.eGet((EStructuralFeature)this._referencedFeature) : containedElement;
            if (!referencedElements.contains(referencedObject)) continue;
            result.add(containedElement);
        }
        return result;
    }

    protected void refreshViewer() {
        this.loadData(this.semanticElement);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection;
        ISelectionProvider provider = event.getSelectionProvider();
        if (provider instanceof IDelegatedViewer && (selection = event.getSelection()) instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (this.isSelectionValid(obj)) {
                this._deleteBtn.setEnabled(true);
            } else {
                this._deleteBtn.setEnabled(false);
            }
        }
    }

    protected boolean isSelectionValid(Object selection) {
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this._delegatedViewer != null) {
            this._delegatedViewer.setEnabled(enabled);
        }
        if (this._deleteBtn != null && !this._deleteBtn.isDisposed()) {
            this._deleteBtn.setEnabled(enabled);
        }
    }
}

