/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.fields;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.linkedtext.ui.LinkedTextDocument;
import org.polarsys.capella.core.data.capellacore.Constraint;
import org.polarsys.capella.core.data.information.datavalue.OpaqueExpression;
import org.polarsys.capella.core.linkedtext.ui.CapellaEmbeddedLinkedTextEditor;
import org.polarsys.capella.core.linkedtext.ui.CapellaEmbeddedLinkedTextEditorInput;
import org.polarsys.capella.core.model.helpers.ConstraintExt;
import org.polarsys.capella.core.ui.properties.controllers.ConstraintController;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.EditableSemanticFieldException;
import org.polarsys.capella.core.ui.properties.fields.Messages;
import org.polarsys.capella.core.ui.properties.helpers.DialogHelper;
import org.polarsys.capella.core.ui.properties.helpers.LockHelper;
import org.polarsys.capella.core.ui.toolkit.ToolkitPlugin;

public class ConstraintReferenceField
extends AbstractSemanticField {
    public static final String DEFAULT_CONSTRAINT_NAME = "";
    protected ConstraintController _controller;
    private final Label _labelTextArea;
    private final Composite _textArea;
    protected Button _valueOpenBtn;
    protected Button _valueDelBtn;
    protected Button _valueEditBtn;
    private Constraint _currentConstraint;

    public ConstraintReferenceField(Composite parent, String label, TabbedPropertySheetWidgetFactory widgetFactory, boolean displayOpenButton, ConstraintController controller) {
        super(widgetFactory);
        this._controller = controller;
        this._labelTextArea = widgetFactory.createLabel(parent, label);
        this._labelTextArea.setLayoutData((Object)new GridData(4, 128, false, false));
        this._textArea = widgetFactory.createComposite(parent);
        Text t = widgetFactory.createText(this._textArea, DEFAULT_CONSTRAINT_NAME, 8);
        GridData gd = new GridData(768);
        gd.heightHint = t.getLineHeight() * 3 + 5;
        gd.widthHint = 150;
        this._textArea.setLayoutData((Object)gd);
        this._textArea.setLayout((Layout)new FillLayout());
        this.createEditButton(parent);
        if (displayOpenButton) {
            this.createOpenButton(parent);
        }
        this.createDeleteButton(parent);
    }

    @Override
    protected Button createButton(Composite parent, Image image, String tooltip) {
        Button button = super.createButton(parent, image, tooltip);
        button.setLayoutData((Object)new GridData(4, 128, false, false));
        return button;
    }

    public void createConstraintNameTextField(final EObject semanticElement, final EStructuralFeature semanticFeature) {
        String text = this._controller.loadText(semanticElement, semanticFeature);
        final Text defaultTextField = this.widgetFactory.createText(this._textArea, text);
        defaultTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

                    public void run() {
                        (this).ConstraintReferenceField.this._controller.editText(semanticElement, semanticFeature, defaultTextField.getText());
                    }
                };
                ConstraintReferenceField.this.executeCommand((ICommand)command);
            }
        });
    }

    public void createDefaultTextTextField(final EObject semanticElement, final EStructuralFeature semanticFeature) {
        String text = this._controller.loadText(semanticElement, semanticFeature);
        final Text defaultTextField = this.widgetFactory.createText(this._textArea, text, 514);
        defaultTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

                    public void run() {
                        (this).ConstraintReferenceField.this._controller.editText(semanticElement, semanticFeature, defaultTextField.getText());
                    }
                };
                ConstraintReferenceField.this.executeCommand((ICommand)command);
            }
        });
    }

    protected void createDeleteButton(Composite parent_p) {
        ImageRegistry imgRegistry = ToolkitPlugin.getDefault().getImageRegistry();
        Image removeImage = imgRegistry.get("toolitem.remove");
        String tooltip = Messages.BrowseSemanticField_DelBtn;
        this._valueDelBtn = this.createButton(parent_p, removeImage, tooltip);
    }

    protected void createEditButton(Composite parent) {
        ImageRegistry imgRegistry = ToolkitPlugin.getDefault().getImageRegistry();
        Image editImage = imgRegistry.get("toolitem.edit");
        String tooltip = Messages.BrowseSemanticField_EditBtn;
        this._valueEditBtn = this.createButton(parent, editImage, tooltip);
    }

    public void createLinkedTextEditor(final EObject semanticElement, final EStructuralFeature semanticFeature) {
        CapellaEmbeddedLinkedTextEditor editor = new CapellaEmbeddedLinkedTextEditor(this._textArea, 0x300 | this.widgetFactory.getBorderStyle());
        final CapellaEmbeddedLinkedTextEditorInput input = new CapellaEmbeddedLinkedTextEditorInput(semanticElement){

            public String getText() {
                return ConstraintReferenceField.this._controller.loadText(semanticElement, semanticFeature);
            }

            public void setText(final String linkedText) {
                if ((linkedText == null || linkedText.isEmpty()) && ConstraintReferenceField.this._controller.getElementToEdit(semanticElement, semanticFeature) == null) {
                    return;
                }
                AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

                    public void run() {
                        EObject constraint = (this).ConstraintReferenceField.this._controller.loadValue(semanticElement, semanticFeature);
                        (this).ConstraintReferenceField.this._controller.editText(semanticElement, semanticFeature, linkedText);
                        constraint = (this).ConstraintReferenceField.this._controller.loadValue(semanticElement, semanticFeature);
                        (this).ConstraintReferenceField.this._currentConstraint = (Constraint)constraint;
                    }
                };
                ConstraintReferenceField.this.executeCommand((ICommand)command);
            }
        };
        editor.getSourceViewer().getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                input.dispose();
            }
        });
        editor.setInput((LinkedTextDocument.Input)input);
    }

    protected void createOpenButton(Composite parent) {
        ImageRegistry imgRegistry = ToolkitPlugin.getDefault().getImageRegistry();
        Image openImage = imgRegistry.get("toolitem.browse");
        String tooltip = Messages.BrowseSemanticField_BrowseBtn;
        this._valueOpenBtn = this.createButton(parent, openImage, tooltip);
    }

    protected void doDeleteCommand(EObject element, EStructuralFeature feature) {
        if (feature.isMany()) {
            this.removeAllDataValue(element, feature);
        } else {
            this.setDataValue(element, feature, null);
        }
        this.loadData(element, feature);
        if (this._valueEditBtn != null) {
            this._valueEditBtn.setEnabled(true);
        }
    }

    protected AbstractReadWriteCommand getDeleteCommand(final EObject element, final EStructuralFeature feature) {
        return new AbstractReadWriteCommand(){

            public void run() {
                ConstraintReferenceField.this.doDeleteCommand(element, feature);
            }
        };
    }

    protected void handleDeleteButtonClicked() {
        AbstractReadWriteCommand command = this.getDeleteCommand(this.semanticElement, this.semanticFeature);
        this.executeCommand((ICommand)command);
    }

    protected void handleEditButtonClicked() throws EditableSemanticFieldException {
        AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

            public String getName() {
                return "Edit " + String.valueOf(ConstraintReferenceField.this.semanticElement.eGet((EStructuralFeature)ModellingcorePackage.eINSTANCE.getAbstractNamedElement_Name()));
            }

            public void run() {
                ConstraintReferenceField.this._controller.editValue(ConstraintReferenceField.this.semanticElement, ConstraintReferenceField.this.semanticFeature, ConstraintReferenceField.DEFAULT_CONSTRAINT_NAME);
            }
        };
        this.executeCommand((ICommand)command);
    }

    protected void handleOpenButtonClicked(final Button button) {
        AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

            public String getName() {
                return "Edit " + String.valueOf(ConstraintReferenceField.this.semanticElement.eGet((EStructuralFeature)ModellingcorePackage.eINSTANCE.getAbstractNamedElement_Name()));
            }

            public void run() {
                List<EObject> list = ConstraintReferenceField.this._controller.readOpenValues(ConstraintReferenceField.this.semanticElement, ConstraintReferenceField.this.semanticFeature);
                EObject firstResult = DialogHelper.openSimpleSelectionDialog((Control)button, list);
                if (firstResult != null) {
                    ConstraintReferenceField.this._controller.writeOpenValue(ConstraintReferenceField.this.semanticElement, ConstraintReferenceField.this.semanticFeature, ConstraintReferenceField.DEFAULT_CONSTRAINT_NAME, firstResult);
                }
            }
        };
        this.executeCommand((ICommand)command);
    }

    @Override
    public void loadData(EObject semanticElement) {
        this.loadData(semanticElement, this.semanticFeature);
    }

    @Override
    public void loadData(EObject semanticElement, EStructuralFeature semanticFeature) {
        super.loadData(semanticElement, semanticFeature);
        if (this._controller == null) {
            return;
        }
        EObject constraint = this._controller.loadValue(semanticElement, semanticFeature);
        if (constraint != null && constraint == this._currentConstraint) {
            return;
        }
        this._currentConstraint = (Constraint)constraint;
        this.updateTextbox(this._textArea);
    }

    private void updateTextbox(Composite textArea) {
        Control[] controlArray = this._textArea.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        EObject elementToEdit = this._controller.getElementToEdit(this.semanticElement, this.semanticFeature);
        boolean useLinkedTextEditor = false;
        if (elementToEdit == null) {
            useLinkedTextEditor = true;
        } else if (elementToEdit instanceof OpaqueExpression) {
            OpaqueExpression expression = (OpaqueExpression)elementToEdit;
            boolean bl = useLinkedTextEditor = !ConstraintExt.hasBodies((OpaqueExpression)expression) || ConstraintExt.hasPrimaryLinkedText((OpaqueExpression)expression);
        }
        if (useLinkedTextEditor) {
            this.createLinkedTextEditor(this.semanticElement, this.semanticFeature);
        } else if (elementToEdit instanceof OpaqueExpression) {
            this.createDefaultTextTextField(this.semanticElement, this.semanticFeature);
        } else if (elementToEdit instanceof Constraint) {
            this.createConstraintNameTextField(this.semanticElement, this.semanticFeature);
        }
        this._textArea.layout(true, true);
    }

    @Override
    public void setEnabled(boolean enabled) {
        LockHelper.getInstance().enable((Control)this._labelTextArea, enabled);
        LockHelper.getInstance().enable((Control)this._textArea, enabled);
        LockHelper.getInstance().enable((Control)this._valueDelBtn, enabled);
        LockHelper.getInstance().enable((Control)this._valueEditBtn, enabled);
        LockHelper.getInstance().enable((Control)this._valueOpenBtn, enabled);
    }

    public void setVisible(boolean status) {
        this._labelTextArea.setVisible(status);
        this._textArea.setVisible(status);
        this.setVisibleDeleteButton(status);
        this.setVisibleEditButton(status);
        this.setVisibleOpenButton(status);
    }

    protected void setVisibleDeleteButton(boolean status) {
        if (this._valueDelBtn != null) {
            this._valueDelBtn.setVisible(status);
        }
    }

    protected void setVisibleEditButton(boolean status) {
        if (this._valueEditBtn != null) {
            this._valueEditBtn.setVisible(status);
        }
    }

    protected void setVisibleOpenButton(boolean status) {
        if (this._valueOpenBtn != null) {
            this._valueOpenBtn.setVisible(status);
        }
    }

    @Override
    public void widgetSelected(SelectionEvent event) {
        Object source;
        if (event != null && (source = event.getSource()) != null) {
            if (source.equals(this._valueOpenBtn)) {
                this.handleOpenButtonClicked(this._valueOpenBtn);
            } else if (source.equals(this._valueDelBtn)) {
                this.handleDeleteButtonClicked();
            } else if (source.equals(this._valueEditBtn)) {
                try {
                    this.handleEditButtonClicked();
                }
                catch (EditableSemanticFieldException editableSemanticFieldException) {
                    // empty catch block
                }
            }
            this.updateTextbox(this._textArea);
        }
    }
}

