/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.fields;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticGroup;
import org.polarsys.capella.core.ui.properties.fields.Messages;
import org.polarsys.capella.core.ui.toolkit.ToolkitPlugin;

public class TextValueGroup
extends AbstractSemanticGroup {
    protected Text valueField;
    protected Button valueResetBtn;

    public TextValueGroup(Composite parent, String label, TabbedPropertySheetWidgetFactory widgetFactory) {
        this(parent, label, widgetFactory, false, false);
    }

    public TextValueGroup(Composite parent, String label, TabbedPropertySheetWidgetFactory widgetFactory, boolean skipGroup) {
        this(parent, label, widgetFactory, false, skipGroup);
    }

    public TextValueGroup(Composite parent, String label, TabbedPropertySheetWidgetFactory widgetFactory, boolean hasResetBtn, boolean skipGroup) {
        super(parent, widgetFactory, skipGroup);
        this.createValueTextField(label, hasResetBtn);
    }

    protected void createValueTextField(String label, boolean hasResetBtn) {
        Composite main = this.widgetFactory.createComposite(this.parent);
        main.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(768);
        gd.horizontalSpan = ((GridLayout)this.parent.getLayout()).numColumns;
        main.setLayoutData((Object)gd);
        this.widgetFactory.createCLabel(main, label);
        this.valueField = this.widgetFactory.createText(main, "");
        gd = new GridData(768);
        gd.widthHint = 150;
        gd.heightHint = 20;
        this.valueField.setLayoutData((Object)gd);
        this.addListeners();
        if (hasResetBtn) {
            this.createResetButton(main);
        }
    }

    protected void createResetButton(Composite parent) {
        ImageRegistry imgRegistry = ToolkitPlugin.getDefault().getImageRegistry();
        Image removeImage = imgRegistry.get("toolitem.remove");
        String tooltip = Messages.TextValueGroup_ValueResetBtn_Label;
        this.valueResetBtn = this.createButton(parent, removeImage, tooltip);
    }

    protected void addListeners() {
        this.valueField.addFocusListener((FocusListener)this);
        this.valueField.addKeyListener((KeyListener)this);
    }

    @Override
    public void loadData(EObject semanticElement, EStructuralFeature semanticFeature) {
        super.loadData(semanticElement, semanticFeature);
        this.loadTextValue();
    }

    @Override
    public void loadData(EObject semanticElement) {
        this.loadTextValue();
    }

    public void loadTextValue() {
        if (this.valueField != null && this.semanticElement != null && this.semanticFeature != null) {
            this.setTextValue(this.valueField, this.semanticElement, this.semanticFeature);
            this.updateResetBtnStatus();
        }
    }

    @Override
    protected void fillTextField(Text textField) {
        if (textField.equals(this.valueField)) {
            this.setDataValue(this.semanticElement, this.semanticFeature, this.valueField.getText());
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.valueField != null && !this.valueField.isDisposed()) {
            this.valueField.setEnabled(enabled);
        }
        if (this.valueResetBtn != null && !this.valueResetBtn.isDisposed()) {
            this.valueResetBtn.setEnabled(enabled);
        }
    }

    @Override
    public void widgetSelected(SelectionEvent event) {
        Object source;
        if (event != null && (source = event.getSource()) != null && source.equals(this.valueResetBtn)) {
            this.handleResetButtonClicked(this.valueResetBtn);
        }
    }

    protected void handleResetButtonClicked(Button button) {
        this.setDataValue(this.semanticElement, this.semanticFeature, null);
        this.setTextValue(this.valueField, this.semanticElement, this.semanticFeature);
    }

    protected void updateResetBtnStatus() {
        if (this.valueResetBtn != null) {
            this.valueResetBtn.setEnabled(this.semanticElement.eGet(this.semanticFeature) != null);
        }
    }

    @Override
    protected void setDataValue(EObject object, EStructuralFeature feature, Object value) {
        super.setDataValue(object, feature, value);
        this.updateResetBtnStatus();
    }
}

