/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.property;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractTypedElement;
import org.polarsys.capella.core.data.capellacore.AbstractPropertyValue;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.CapellacoreFactory;
import org.polarsys.capella.core.data.capellacore.PropertyValueGroup;
import org.polarsys.capella.core.data.capellacore.StringPropertyValue;
import org.polarsys.capella.core.data.cs.Component;

public class PropertiesServices {
    public static Component getComponentType(EObject element) {
        EObject current = element;
        if (current instanceof AbstractTypedElement) {
            current = ((AbstractTypedElement)current).getAbstractType();
        }
        if (current instanceof Component) {
            return (Component)current;
        }
        return null;
    }

    public static String getPropertyValue(CapellaElement element, String[] path, String defaultValue) {
        StringPropertyValue property = PropertiesServices.getRealPropertyValue(element, path, false);
        if (property == null || property.getValue() == null) {
            return defaultValue;
        }
        return property.getValue();
    }

    private static StringPropertyValue getRealPropertyValue(CapellaElement element, String[] path, boolean create) {
        String propertyName = path[path.length - 1];
        CapellaElement root = element;
        int i = 0;
        while (i < path.length - 1) {
            String pathName = path[i];
            boolean foundSubGroup = false;
            if (root == null) break;
            Iterator ownedGroup = root.getOwnedPropertyValueGroups();
            Iterator iterator = ownedGroup.iterator();
            while (iterator.hasNext()) {
                PropertyValueGroup group = (PropertyValueGroup)iterator.next();
                if (!group.getName().equals(pathName)) continue;
                root = group;
                foundSubGroup = true;
                break;
            }
            if (!foundSubGroup) {
                if (create) {
                    PropertyValueGroup propertyGroup = CapellacoreFactory.eINSTANCE.createPropertyValueGroup();
                    CapellaElement toInsert = root;
                    propertyGroup.setName(pathName);
                    toInsert.getOwnedPropertyValueGroups().add((Object)propertyGroup);
                    root = propertyGroup;
                } else {
                    return null;
                }
            }
            ++i;
        }
        if (root != null) {
            StringPropertyValue finalProperty = null;
            EList ownedValues = root.getOwnedPropertyValues();
            for (AbstractPropertyValue property : ownedValues) {
                if (!property.getName().equals(propertyName) || !(property instanceof StringPropertyValue)) continue;
                finalProperty = (StringPropertyValue)property;
                break;
            }
            if (finalProperty == null && root instanceof PropertyValueGroup) {
                ownedValues = ((PropertyValueGroup)root).getAppliedPropertyValues();
                for (AbstractPropertyValue property : ownedValues) {
                    if (!property.getName().equals(propertyName) || !(property instanceof StringPropertyValue)) continue;
                    finalProperty = (StringPropertyValue)property;
                    break;
                }
            }
            if (finalProperty == null && create) {
                StringPropertyValue property = CapellacoreFactory.eINSTANCE.createStringPropertyValue();
                CapellaElement toInsert = root;
                property.setName(propertyName);
                toInsert.getOwnedPropertyValues().add((Object)property);
                finalProperty = property;
            }
            return finalProperty;
        }
        return null;
    }

    public static boolean setPropertyValue(CapellaElement element, String[] path, String value, boolean create) {
        try {
            StringPropertyValue property = PropertiesServices.getRealPropertyValue(element, path, create);
            property.setValue(value);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static void unsetProperty(CapellaElement element, String[] path) {
        try {
            StringPropertyValue property = PropertiesServices.getRealPropertyValue(element, path, false);
            if (property != null) {
                StringPropertyValue propRemove = property;
                if (((CapellaElement)property.eContainer()).getOwnedPropertyValues().contains((Object)propRemove)) {
                    ((CapellaElement)property.eContainer()).getOwnedPropertyValues().remove((Object)propRemove);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

