/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.viewers;

import java.util.ArrayList;
import org.eclipse.emf.common.ui.celleditor.ExtendedComboBoxCellEditor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.business.queries.capellacore.BusinessQueriesProvider;
import org.polarsys.capella.core.data.capellacore.AbstractPropertyValue;
import org.polarsys.capella.core.data.capellacore.BooleanPropertyValue;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyLiteral;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyValue;
import org.polarsys.capella.core.data.capellacore.FloatPropertyValue;
import org.polarsys.capella.core.data.capellacore.IntegerPropertyValue;
import org.polarsys.capella.core.data.capellacore.StringPropertyValue;
import org.polarsys.capella.core.model.handler.provider.CapellaAdapterFactoryProvider;
import org.polarsys.capella.core.ui.properties.viewers.ICellEditorProvider;

public class AbstractPropertyValueCellEditorProvider
implements ICellEditorProvider {
    private static final String VALUE = "value";

    @Override
    public Object getElementValue(EObject element, int column) {
        switch (column) {
            case 0: {
                if (!(element instanceof AbstractPropertyValue)) break;
                String name = ((AbstractPropertyValue)element).getName();
                if (name == null) {
                    name = "";
                }
                return name;
            }
            case 1: {
                if (element instanceof BooleanPropertyValue) {
                    return ((BooleanPropertyValue)element).isValue();
                }
                if (element instanceof IntegerPropertyValue) {
                    return ((IntegerPropertyValue)element).getValue();
                }
                if (element instanceof FloatPropertyValue) {
                    return Float.valueOf(((FloatPropertyValue)element).getValue());
                }
                if (element instanceof StringPropertyValue) {
                    String value = ((StringPropertyValue)element).getValue();
                    if (value == null) {
                        value = "";
                    }
                    return value;
                }
                if (!(element instanceof EnumerationPropertyValue)) break;
                return ((EnumerationPropertyValue)element).getValue();
            }
            case 2: {
                if (!(element instanceof AbstractPropertyValue)) break;
                String summary = ((AbstractPropertyValue)element).getSummary();
                if (summary == null) {
                    summary = "";
                }
                return summary;
            }
        }
        return null;
    }

    @Override
    public void modifyElement(EObject element, int column, Object value) {
        switch (column) {
            case 0: {
                if (!(element instanceof AbstractPropertyValue) || value == null) break;
                ((AbstractPropertyValue)element).setName((String)value);
                break;
            }
            case 1: {
                if (element instanceof BooleanPropertyValue && value != null) {
                    ((BooleanPropertyValue)element).setValue(((Boolean)value).booleanValue());
                    break;
                }
                if (element instanceof IntegerPropertyValue && value != null) {
                    ((IntegerPropertyValue)element).setValue(((Integer)value).intValue());
                    break;
                }
                if (element instanceof FloatPropertyValue && value != null) {
                    ((FloatPropertyValue)element).setValue(((Float)value).floatValue());
                    break;
                }
                if (element instanceof StringPropertyValue && value != null) {
                    ((StringPropertyValue)element).setValue((String)value);
                    break;
                }
                if (!(element instanceof EnumerationPropertyValue)) break;
                ((EnumerationPropertyValue)element).setValue((EnumerationPropertyLiteral)value);
                break;
            }
            case 2: {
                if (!(element instanceof AbstractPropertyValue) || value == null) break;
                ((AbstractPropertyValue)element).setSummary((String)value);
            }
        }
    }

    @Override
    public CellEditor getCellEditor(Composite composite, int column, Object element) {
        switch (column) {
            case 0: {
                return this.createCellEditor(composite, null);
            }
            case 1: {
                if (element instanceof BooleanPropertyValue) {
                    return this.createCellEditor(composite, element);
                }
                if (element instanceof IntegerPropertyValue) {
                    return this.createCellEditor(composite, element);
                }
                if (element instanceof StringPropertyValue) {
                    return this.createCellEditor(composite, element);
                }
                if (element instanceof FloatPropertyValue) {
                    return this.createCellEditor(composite, element);
                }
                if (element instanceof EnumerationPropertyValue) {
                    return this.createCellEditor(composite, element);
                }
                return this.createCellEditor(composite, null);
            }
            case 2: {
                return this.createCellEditor(composite, null);
            }
        }
        return null;
    }

    private CellEditor createCellEditor(Composite composite, Object element) {
        if (element == null) {
            return new TextCellEditor(composite);
        }
        IItemPropertySource provider = (IItemPropertySource)CapellaAdapterFactoryProvider.getInstance().getAdapterFactory().adapt(element, IItemPropertySource.class);
        IItemPropertyDescriptor itemDescriptor = provider.getPropertyDescriptor(element, (Object)VALUE);
        PropertyDescriptor descriptor = new PropertyDescriptor(element, itemDescriptor);
        if (element instanceof EnumerationPropertyValue) {
            ArrayList list = new ArrayList();
            IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(CapellacorePackage.Literals.ENUMERATION_PROPERTY_VALUE, (EStructuralFeature)CapellacorePackage.Literals.ENUMERATION_PROPERTY_VALUE__VALUE);
            if (query != null) {
                list.addAll(query.getCurrentElements((EObject)((CapellaElement)element), false));
                list.addAll(query.getAvailableElements((EObject)((CapellaElement)element)));
            }
            if (!list.contains(null)) {
                list.add(0, null);
            }
            return new ExtendedComboBoxCellEditor(composite, list, descriptor.getLabelProvider(), itemDescriptor.isSortChoices(element));
        }
        return descriptor.createPropertyEditor(composite);
    }
}

