/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.wizards;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IHelpResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyRegistry;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyRegistryFactory;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.ISectionDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.polarsys.capella.common.ui.services.helper.FormHelper;
import org.polarsys.capella.core.model.utils.NamingHelper;
import org.polarsys.capella.core.ui.properties.sections.IAbstractSection;
import org.polarsys.capella.core.ui.properties.wizards.EditCapellaCustomPropertyWizard;
import org.polarsys.capella.core.ui.properties.wizards.Messages;
import org.polarsys.capella.core.ui.resources.CapellaUIResourcesPlugin;

public class EditCapellaCustomPropertyWizardPage
extends WizardPage
implements ITabbedPropertySheetPageContributor {
    private FormToolkit toolkit;
    private HelpListener helpListener = null;
    private Composite comp = null;
    private Collection<ISection> sections = null;
    private IWorkbenchPart part;

    public EditCapellaCustomPropertyWizardPage(IWorkbenchPart part, String pageName, EObject element, String metaclassLabel) {
        super(pageName);
        this.setTitle(NamingHelper.getTitleLabel((EObject)element));
        this.setDescription(NLS.bind((String)Messages.editCapellaCustomPropertyWizardPage_Description, (Object)metaclassLabel));
        ImageDescriptor imageDescriptor = CapellaUIResourcesPlugin.getDefault().getPNGImage(element);
        if (imageDescriptor != null) {
            this.setImageDescriptor(imageDescriptor);
        }
        this.part = part;
    }

    private Composite createComposite(Composite parent, FormToolkit toolkit) {
        ScrolledForm scrolledContainer = toolkit.createScrolledForm(parent);
        this.setControl((Control)scrolledContainer);
        Composite content = scrolledContainer.getBody();
        content.setLayoutData((Object)new GridData(1808));
        content.setLayout((Layout)new GridLayout());
        return content;
    }

    protected boolean sectionDisplayedOnWizard(ISectionDescriptor section) {
        return !"org.polarsys.capella.common.data.modellingcore.section.advanced.ModelElement".equals(section.getId());
    }

    public void createControl(Composite parent) {
        TabbedPropertyRegistry registry = TabbedPropertyRegistryFactory.getInstance().createRegistry((ITabbedPropertySheetPageContributor)this);
        StructuredSelection selection = new StructuredSelection((Object)this.getEObject());
        this.sections = new ArrayList<ISection>();
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.toolkit.setBackground(parent.getBackground());
        Composite content = this.createComposite(parent, this.toolkit);
        this.initializeDialogUnits((Control)content);
        EObject object = this.getEObject();
        final CTabFolder tabFolder = new CTabFolder(content, 2048);
        tabFolder.setLayoutData((Object)new GridData(1808));
        tabFolder.setSimple(false);
        tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object data = tabFolder.getSelection().getData();
                if (data instanceof ISection) {
                    ((ISection)data).refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        ITabDescriptor[] iTabDescriptorArray = registry.getTabDescriptors(this.part, (ISelection)selection);
        int n = iTabDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITabDescriptor descriptor = iTabDescriptorArray[n2];
            Composite tabItemContent = new Composite((Composite)tabFolder, 0);
            tabItemContent.setLayout((Layout)new GridLayout());
            tabItemContent.setLayoutData((Object)new GridData(1808));
            List descriptors = descriptor.getSectionDescriptors().stream().map(ISectionDescriptor.class::cast).filter(x -> this.sectionDisplayedOnWizard((ISectionDescriptor)x)).collect(Collectors.toList());
            if (!descriptors.isEmpty()) {
                CTabItem tabItem = new CTabItem(tabFolder, 0);
                tabItem.setText(descriptor.getLabel());
                tabItem.setControl((Control)tabItemContent);
                for (ISectionDescriptor sd : descriptors) {
                    ISectionDescriptor sectionDescriptor = sd;
                    ISection section = sectionDescriptor.getSectionClass();
                    if (section == null) continue;
                    Composite sectionComposite = new Composite(tabItemContent, 0);
                    sectionComposite.setLayout((Layout)new FillLayout());
                    int style = section.shouldUseExtraSpace() ? 1808 : 768;
                    GridData data = new GridData(style);
                    data.heightHint = section.getMinimumHeight();
                    sectionComposite.setLayoutData((Object)data);
                    section.createControls(sectionComposite, null);
                    section.setInput(this.part, (ISelection)new StructuredSelection((Object)object));
                    tabItem.setData((Object)section);
                    this.sections.add(section);
                }
            }
            ++n2;
        }
        FormHelper.adaptBackgroundColor((Control)content, (Color)content.getDisplay().getSystemColor(22), (boolean)false);
        final IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        final EClass eclass = object.eClass();
        if (this.comp != null && this.helpListener != null) {
            this.comp.removeHelpListener(this.helpListener);
        }
        this.helpListener = new HelpListener(){

            private boolean isHelpAvailable() {
                return this.checkIfHelpIsAvailable(eclass);
            }

            protected boolean checkIfHelpIsAvailable(EClass eclass2) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (InputStream inputStream = HelpSystem.getHelpContent((String)this.generateHTMLLink(eclass2));){
                        boolean bl = eclass2 != null && inputStream != null;
                        return bl;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception exception) {
                    return false;
                }
            }

            public void helpRequested(HelpEvent e) {
                IContext c = new IContext(){

                    public String getText() {
                        if (!this.isHelpAvailable()) {
                            return NLS.bind((String)Messages.editCapellaCustomPropertyWizardPage_MainDescriptionKO, (Object)eclass.getName());
                        }
                        return null;
                    }

                    public IHelpResource[] getRelatedTopics() {
                        IHelpResource[] iHelpResourceArray;
                        IHelpResource hr = null;
                        if (this.isHelpAvailable()) {
                            hr = new IHelpResource(){

                                public String getLabel() {
                                    return NLS.bind((String)Messages.editCapellaCustomPropertyWizardPage_RLLinkName, (Object)eclass.getName());
                                }

                                public String getHref() {
                                    return this.generateHTMLLink(eclass);
                                }
                            };
                        }
                        if (hr != null) {
                            IHelpResource[] iHelpResourceArray2 = new IHelpResource[1];
                            iHelpResourceArray = iHelpResourceArray2;
                            iHelpResourceArray2[0] = hr;
                        } else {
                            iHelpResourceArray = null;
                        }
                        return iHelpResourceArray;
                    }
                };
                helpSystem.displayContext(c, 0, 0);
            }

            protected String generateHTMLLink(EClass eclass2) {
                return "/org.polarsys.capella.core.doc.user/html/editors/" + eclass2.getEPackage().getName() + "/" + eclass2.getName() + ".html";
            }
        };
        this.comp = parent;
        this.comp.addHelpListener(this.helpListener);
    }

    public void dispose() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
        if (this.comp != null && this.helpListener != null) {
            this.comp.removeHelpListener(this.helpListener);
            this.helpListener = null;
            this.comp.dispose();
            this.comp = null;
        }
        if (this.sections != null) {
            for (ISection section : this.sections) {
                section.dispose();
            }
            this.sections = null;
        }
        this.getImage().dispose();
        TabbedPropertyRegistryFactory.getInstance().disposeRegistry((ITabbedPropertySheetPageContributor)this);
    }

    protected EObject getEObject() {
        return ((EditCapellaCustomPropertyWizard)this.getWizard()).getEObject();
    }

    public void performFinish() {
        this.sections.stream().filter(IAbstractSection.class::isInstance).map(IAbstractSection.class::cast).forEach(IAbstractSection::performFinish);
    }

    public Collection<ISection> getSections() {
        return this.sections;
    }

    public String getContributorId() {
        return "org.polarsys.capella.core.data.capellamodeller.properties";
    }
}

