/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.detachment.version.precondition.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarsys.capella.common.bundle.FeatureHelper;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.model.handler.helpers.CapellaFeatureHelper;
import org.polarsys.capella.detachment.version.precondition.util.SAXModelsElementsParser;
import org.polarsys.kitalpha.model.common.precondition.exception.InvalidPreconditionException;
import org.polarsys.kitalpha.model.common.precondition.interfaces.IPrecondition;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class VersionChecker
implements IPrecondition<IFile> {
    private static final Logger logger = ReportManagerRegistry.getInstance().subscribe("Model Management");

    public void executePrecondition(IFile param, IProgressMonitor monitor) throws InvalidPreconditionException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setNamespaceAware(false);
        try {
            String projectName = param.getProject().getName();
            SAXModelsElementsParser modelsEltParser = SAXModelsElementsParser.newInstance(projectName);
            SAXParser saxParser = parserFactory.newSAXParser();
            saxParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            saxParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setContentHandler(modelsEltParser);
            InputSource is = new InputSource();
            is.setByteStream(param.getContents());
            xmlReader.parse(is);
            Collection<IFile> capellaModellers = modelsEltParser.getCapellaModellers();
            capellaModellers.add(param);
            String capellaVersion = FeatureHelper.getCapellaVersion((boolean)false);
            HashSet<StringBuffer> result = new HashSet<StringBuffer>();
            for (IFile iFile : capellaModellers) {
                String modelVersion = CapellaFeatureHelper.getDetectedVersion((IFile)iFile);
                if (modelVersion == null || modelVersion.isEmpty() || modelVersion.startsWith(capellaVersion.substring(0, 3))) continue;
                StringBuffer _msg = new StringBuffer();
                _msg.append(iFile.getName()).append(": model version is: ").append(modelVersion).append(". It needs to be migrated to ").append("Capella ").append(capellaVersion).append(".\n");
                result.add(_msg);
            }
            if (!result.isEmpty()) {
                String _msg = this.assembleMessage(result);
                throw new InvalidPreconditionException(_msg);
            }
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)e.getMessage());
        }
        catch (SAXException e) {
            logger.error((Object)e.getMessage());
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
        }
        catch (CoreException e) {
            logger.error((Object)e.getMessage());
        }
    }

    private String assembleMessage(Collection<StringBuffer> result) {
        Object _msg = "";
        for (StringBuffer m : result) {
            _msg = (String)_msg + m.toString();
        }
        return _msg;
    }
}

