/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.detachment.version.precondition.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXModelsElementsParser
extends DefaultHandler {
    private static final Logger logger = ReportManagerRegistry.getInstance().subscribe("Model Management");
    private static final String HREF_ATTR = "href";
    private static final String MODELS_TAG = "models";
    Collection<IFile> capellaModellers;
    public final IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
    private String projectName = null;

    public static SAXModelsElementsParser newInstance(String projectName) {
        return new SAXModelsElementsParser(projectName);
    }

    private SAXModelsElementsParser(String projectName) {
        this.projectName = projectName;
    }

    @Override
    public void startDocument() throws SAXException {
        this.capellaModellers = new HashSet<IFile>();
    }

    @Override
    public void startElement(String namespaceURI, String name, String qname, Attributes attr) throws SAXException {
        IResource resource;
        String fileModelName;
        if (qname != null && qname.equals(MODELS_TAG) && (fileModelName = attr.getValue(HREF_ATTR)) != null && !fileModelName.isEmpty() && (resource = this.findResource(fileModelName)) != null && resource.getType() == 1 && resource.exists() && resource.isAccessible()) {
            this.capellaModellers.add((IFile)resource);
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    public Collection<IFile> getCapellaModellers() {
        return this.capellaModellers;
    }

    private IResource findResource(String path) {
        try {
            if (path != null) {
                URI uri = URI.createURI((String)(path = URLDecoder.decode(path, "UTF-8"))).trimFragment();
                if (uri.isPlatformResource()) {
                    path = this.computeResourcePath(uri);
                    String projectName = uri.segment(1);
                    IProject project = this.wsRoot.getProject(projectName);
                    IResource resource = project.findMember(path);
                    return resource;
                }
                IProject project = this.wsRoot.getProject(this.projectName);
                path = this.computeResourcePath(uri);
                IResource resource = project.findMember(path);
                return resource;
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.warn((Object)e.getMessage());
        }
        return null;
    }

    private String computeResourcePath(URI uri) {
        String[] segments = uri.segments();
        Object path = "";
        int i = 0;
        i = uri.isPlatformResource() ? 2 : 0;
        while (i < segments.length - 1) {
            path = (String)path + segments[i] + "/";
            ++i;
        }
        return (String)path + uri.lastSegment();
    }
}

