/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.massactions.core.shared.helper;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.polarsys.capella.common.ui.massactions.core.shared.helper.container.CommonBQInput;
import org.polarsys.capella.common.ui.massactions.core.shared.helper.container.CommonBQResult;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.business.queries.capellacore.BusinessQueriesProvider;

public class CommonElementsHelper {
    private CommonElementsHelper() {
    }

    private static IBusinessQuery getBusinessQuery(ILayerCell cell, Map<String, List<EStructuralFeature>> featureMap, IRowDataProvider<EObject> bodyDataProvider) {
        int rowIndex = cell.getRowIndex();
        int columnIndex = cell.getColumnIndex();
        EObject rowObject = (EObject)bodyDataProvider.getRowObject(rowIndex);
        EStructuralFeature feature = featureMap.get(rowObject.eClass().getName()).get(columnIndex);
        return CommonElementsHelper.getBusinessQuery(feature);
    }

    public static IBusinessQuery getBusinessQuery(EStructuralFeature feature) {
        return BusinessQueriesProvider.getInstance().getContribution(feature.getEContainingClass(), feature);
    }

    public static CommonBQResult getAllCommonBusinessQueryResults(List<ILayerCell> currentCells, Map<String, List<EStructuralFeature>> featureMap, IRowDataProvider<EObject> bodyDataProvider) {
        if (currentCells.isEmpty()) {
            return CommonBQResult.emptyResult();
        }
        ILayerCell sampleCell = currentCells.get(0);
        IBusinessQuery sampleCellQuery = CommonElementsHelper.getBusinessQuery(sampleCell, featureMap, bodyDataProvider);
        if (sampleCellQuery == null) {
            return CommonBQResult.emptyResult();
        }
        EObject rowObject = (EObject)bodyDataProvider.getRowObject(sampleCell.getRowIndex());
        HashSet<EObject> commonAvailableElements = new HashSet<EObject>(sampleCellQuery.getAvailableElements(rowObject));
        HashSet<EObject> commonCurrentElements = new HashSet<EObject>(sampleCellQuery.getCurrentElements(rowObject, false));
        if (currentCells.size() > 1) {
            commonAvailableElements.addAll(commonCurrentElements);
        }
        int i = 1;
        while (i < currentCells.size()) {
            sampleCell = currentCells.get(i);
            sampleCellQuery = CommonElementsHelper.getBusinessQuery(sampleCell, featureMap, bodyDataProvider);
            if (sampleCellQuery == null) {
                return CommonBQResult.emptyResult();
            }
            rowObject = (EObject)bodyDataProvider.getRowObject(sampleCell.getRowIndex());
            List availableElements = sampleCellQuery.getAvailableElements(rowObject);
            List currentElements = sampleCellQuery.getCurrentElements(rowObject, false);
            availableElements.addAll(currentElements);
            commonAvailableElements.retainAll(availableElements);
            commonCurrentElements.retainAll(currentElements);
            ++i;
        }
        return new CommonBQResult(commonAvailableElements, commonCurrentElements);
    }

    public static CommonBQResult getAllCommonBusinessQueryResults(List<CommonBQInput> inputElements) {
        if (inputElements.isEmpty()) {
            return CommonBQResult.emptyResult();
        }
        CommonBQInput sampleInput = inputElements.get(0);
        EStructuralFeature sampleFeature = sampleInput.getColumnFeature();
        IBusinessQuery sampleQuery = CommonElementsHelper.getBusinessQuery(sampleFeature);
        if (sampleQuery == null) {
            return CommonBQResult.emptyResult();
        }
        EObject sampleRowObject = sampleInput.getRowObject();
        HashSet<EObject> commonAvailableElements = new HashSet<EObject>(sampleQuery.getAvailableElements(sampleRowObject));
        HashSet<EObject> commonCurrentElements = new HashSet<EObject>(sampleQuery.getCurrentElements(sampleRowObject, false));
        if (inputElements.size() > 1) {
            commonAvailableElements.addAll(commonCurrentElements);
        }
        int i = 1;
        while (i < inputElements.size()) {
            sampleInput = inputElements.get(i);
            sampleFeature = sampleInput.getColumnFeature();
            sampleQuery = CommonElementsHelper.getBusinessQuery(sampleFeature);
            if (sampleQuery == null) {
                return CommonBQResult.emptyResult();
            }
            sampleRowObject = sampleInput.getRowObject();
            List availableElements = sampleQuery.getAvailableElements(sampleRowObject);
            List currentElements = sampleQuery.getCurrentElements(sampleRowObject, false);
            availableElements.addAll(currentElements);
            commonAvailableElements.retainAll(availableElements);
            commonCurrentElements.retainAll(currentElements);
            ++i;
        }
        return new CommonBQResult(commonAvailableElements, commonCurrentElements);
    }
}

