/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.interaction.ui.quickfix.resolver;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewHelper;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.model.helpers.AbstractCapabilityExt;
import org.polarsys.capella.core.validation.ui.ide.PluginActivator;
import org.polarsys.capella.core.validation.ui.ide.quickfix.AbstractCapellaMarkerResolution;

public class AddInvolvedElementsResolver
extends AbstractCapellaMarkerResolution {
    private final String PROCESS_ICON = "icons/full/obj16/capella_process.gif";
    private final String overridenLabel;
    private final String ruleId;
    private boolean multiMarkerQuickFix;

    public AddInvolvedElementsResolver(String label, boolean multiMarkerQuickFix, String ruleId) {
        this.overridenLabel = label;
        this.multiMarkerQuickFix = multiMarkerQuickFix;
        this.ruleId = ruleId;
        super.setContributorId("org.polarsys.capella.core.ui.resources");
        super.setImgKey("icons/full/obj16/capella_process.gif");
    }

    public String getLabel() {
        return this.overridenLabel;
    }

    public boolean enabled(Collection<IMarker> markers) {
        return markers.size() > 1 || !this.multiMarkerQuickFix;
    }

    public void run(IMarker marker) {
        final List modelElements = this.getModelElements(marker);
        if (!modelElements.isEmpty()) {
            this.getExecutionManager(marker).execute((ICommand)new AbstractReadWriteCommand(){

                public void run() {
                    AbstractCapability capability = null;
                    Optional<EObject> found = modelElements.stream().filter(AbstractCapability.class::isInstance).findFirst();
                    if (found.isPresent()) {
                        capability = (AbstractCapability)found.get();
                    }
                    if (capability != null) {
                        for (EObject obj : modelElements) {
                            if (obj instanceof Component) {
                                Component component = (Component)obj;
                                if (AbstractCapabilityExt.getInvolvedComponents((AbstractCapability)capability).contains(component)) continue;
                                AbstractCapabilityExt.addInvolvedComponent((AbstractCapability)capability, (Component)component);
                                continue;
                            }
                            if (obj instanceof AbstractFunction) {
                                AbstractFunction function = (AbstractFunction)obj;
                                if (capability.getInvolvedAbstractFunctions().contains((Object)function)) continue;
                                AbstractCapabilityExt.addInvolvedFunction((AbstractCapability)capability, (AbstractFunction)function);
                                continue;
                            }
                            if (!(obj instanceof FunctionalChain)) continue;
                            FunctionalChain functionalChain = (FunctionalChain)obj;
                            if (capability.getInvolvedFunctionalChains().contains((Object)functionalChain)) continue;
                            AbstractCapabilityExt.addInvolvedFunctionalChain((AbstractCapability)capability, (FunctionalChain)functionalChain);
                        }
                    }
                }
            });
        }
        this.deleteMarker(marker);
    }

    protected ExecutionManager getExecutionManager(IMarker marker) {
        return TransactionHelper.getExecutionManager((Collection)this.getModelElements(marker));
    }

    protected void deleteMarker(IMarker marker) {
        if (marker.exists()) {
            try {
                marker.delete();
            }
            catch (CoreException e) {
                PluginActivator.getDefault().log(4, e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    protected boolean canResolve(IMarker marker) {
        String markerRuleId = MarkerViewHelper.getRuleID((IMarker)marker, (boolean)true);
        return this.multiMarkerQuickFix && this.ruleId.equals(markerRuleId);
    }

    public String getRuleId() {
        return this.ruleId;
    }
}

