/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CollectionKind implements Enumerator
{
    ARRAY(0, "ARRAY", "ARRAY"),
    SEQUENCE(1, "SEQUENCE", "SEQUENCE");

    public static final int ARRAY_VALUE = 0;
    public static final int SEQUENCE_VALUE = 1;
    private static final CollectionKind[] VALUES_ARRAY;
    public static final List<CollectionKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CollectionKind[]{ARRAY, SEQUENCE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CollectionKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CollectionKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CollectionKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CollectionKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CollectionKind get(int value) {
        switch (value) {
            case 0: {
                return ARRAY;
            }
            case 1: {
                return SEQUENCE;
            }
        }
        return null;
    }

    private CollectionKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

