/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.interaction;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MessageKind implements Enumerator
{
    UNSET(0, "UNSET", "UNSET"),
    ASYNCHRONOUS_CALL(1, "ASYNCHRONOUS_CALL", "ASYNCHRONOUS_CALL"),
    SYNCHRONOUS_CALL(2, "SYNCHRONOUS_CALL", "SYNCHRONOUS_CALL"),
    REPLY(3, "REPLY", "REPLY"),
    DELETE(4, "DELETE", "DELETE"),
    CREATE(5, "CREATE", "CREATE"),
    TIMER(6, "TIMER", "TIMER");

    public static final int UNSET_VALUE = 0;
    public static final int ASYNCHRONOUS_CALL_VALUE = 1;
    public static final int SYNCHRONOUS_CALL_VALUE = 2;
    public static final int REPLY_VALUE = 3;
    public static final int DELETE_VALUE = 4;
    public static final int CREATE_VALUE = 5;
    public static final int TIMER_VALUE = 6;
    private static final MessageKind[] VALUES_ARRAY;
    public static final List<MessageKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MessageKind[]{UNSET, ASYNCHRONOUS_CALL, SYNCHRONOUS_CALL, REPLY, DELETE, CREATE, TIMER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MessageKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MessageKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MessageKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MessageKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MessageKind get(int value) {
        switch (value) {
            case 0: {
                return UNSET;
            }
            case 1: {
                return ASYNCHRONOUS_CALL;
            }
            case 2: {
                return SYNCHRONOUS_CALL;
            }
            case 3: {
                return REPLY;
            }
            case 4: {
                return DELETE;
            }
            case 5: {
                return CREATE;
            }
            case 6: {
                return TIMER;
            }
        }
        return null;
    }

    private MessageKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

