/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.semantic.browser.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.polarsys.capella.common.ui.toolkit.browser.category.CategoryImpl;
import org.polarsys.capella.common.ui.toolkit.browser.category.ICategory;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.CategoryWrapper;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.EObjectWrapper;
import org.polarsys.capella.common.ui.toolkit.browser.model.ISemanticBrowserModel;
import org.polarsys.capella.core.ui.semantic.browser.view.TreeItemListenerForHistory;

public class SemanticBrowserTree
extends TreeViewer {
    protected ISemanticBrowserModel model;
    protected String browserID;

    public SemanticBrowserTree(Composite parent, ISemanticBrowserModel model_p, String browserID_p) {
        super(parent);
        this.browserID = browserID_p;
        this.model = model_p;
        this.updateAutoExpandLevel();
        this.getTree().addListener(17, (Listener)new TreeItemListenerForHistory(true, this.browserID, this.model, this));
        this.getTree().addListener(18, (Listener)new TreeItemListenerForHistory(false, this.browserID, this.model, this));
    }

    protected void updateAutoExpandLevel() {
        if (this.model.doesLimitateTreeExpansion()) {
            if (this.browserID == "CurrentElementBrowser") {
                this.setAutoExpandLevel(3);
            } else {
                this.setAutoExpandLevel(2);
            }
        } else {
            this.setAutoExpandLevel(-1);
        }
    }

    protected Item[] getSelection(Control widget) {
        TreeItem[] itemlList;
        TreeItem[] treeItemArray = itemlList = ((Tree)widget).getSelection();
        int n = itemlList.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Object data = item.getData();
            if (data instanceof EObjectWrapper) {
                EObjectWrapper wrapper = (EObjectWrapper)data;
                item.setData((Object)wrapper.getElement());
            }
            ++n2;
        }
        return itemlList;
    }

    protected ColumnViewerEditor createViewerEditor() {
        return null;
    }

    protected void initializeHistory() {
        this.model.getOrCreateHistory(this.browserID);
        for (TreeItem treeItem : this.getAllItems()) {
            Object data;
            if (this.getExpanded((Item)treeItem) || (data = treeItem.getData()) == null || !(data instanceof CategoryWrapper)) continue;
            CategoryImpl category = ((CategoryWrapper)data).getElement();
            this.model.saveExpandedState(category, this.browserID, false);
        }
    }

    protected void restoreExpansionState(Object input) {
        TreeItem topItem = this.getTree().getTopItem();
        for (TreeItem treeItem : this.getAllItems()) {
            Object data = treeItem.getData();
            if (data == null || !this.model.doesLimitateTreeExpansion()) continue;
            if (data instanceof CategoryWrapper) {
                CategoryImpl category = ((CategoryWrapper)data).getElement();
                boolean expanded = this.model.getExpandedState((ICategory)category, this.browserID);
                treeItem.setExpanded(expanded);
                continue;
            }
            if (this.browserID == "CurrentElementBrowser" && treeItem == topItem) {
                treeItem.setExpanded(true);
                continue;
            }
            treeItem.setExpanded(false);
        }
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.updateAutoExpandLevel();
        if (oldInput != null && !this.model.containsExpandedHistory(this.browserID)) {
            this.initializeHistory();
        }
        super.inputChanged(input, oldInput);
        if (input != null && this.model.containsExpandedHistory(this.browserID)) {
            this.restoreExpansionState(input);
        }
    }

    private List<TreeItem> getAllItems() {
        ArrayList<TreeItem> allItems = new ArrayList<TreeItem>();
        TreeItem[] treeItemArray = this.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getData() != null) {
                allItems.add(item);
                this.getAllItems(item, allItems);
            }
            ++n2;
        }
        return allItems;
    }

    private void getAllItems(TreeItem currentItem, List<TreeItem> allItems) {
        TreeItem[] treeItemArray = currentItem.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem element = treeItemArray[n2];
            if (element.getData() != null) {
                allItems.add(element);
                this.getAllItems(element, allItems);
            }
            ++n2;
        }
    }

    protected void handleLabelProviderChanged(LabelProviderChangedEvent event) {
        super.handleLabelProviderChanged(event);
        Object eventTarget = event.getElement();
        ArrayList<Object> additionalElements = new ArrayList<Object>();
        for (TreeItem item : this.getAllItems()) {
            EObject wrapped;
            Object target = item.getData();
            if (!(target instanceof EObjectWrapper) || (wrapped = ((EObjectWrapper)target).getElement()) != eventTarget) continue;
            additionalElements.add(target);
        }
        if (!additionalElements.isEmpty()) {
            LabelProviderChangedEvent delegatedEvent = new LabelProviderChangedEvent((IBaseLabelProvider)event.getSource(), additionalElements.toArray());
            super.handleLabelProviderChanged(delegatedEvent);
        }
    }
}

