/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.ef.command.AbstractReadOnlyCommand;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.ui.actions.AbstractTigAction;
import org.polarsys.capella.common.ui.toolkit.dialogs.SelectElementsDialog;
import org.polarsys.capella.core.platform.sirius.ui.actions.AllocationManagementAction;
import org.polarsys.capella.core.platform.sirius.ui.actions.AllocationManagementData;
import org.polarsys.capella.core.platform.sirius.ui.actions.Messages;
import org.polarsys.capella.core.platform.sirius.ui.actions.WizardActionHelper;

public class AllocationManagementWizardAction
extends AbstractTigAction {
    AllocationManagementAction _actionInstance;
    AllocationManagementData _dataInstance;

    protected List<ModelElement> getSelectedElements() {
        return super.getSelectedElements();
    }

    public void run(IAction action) {
        this._actionInstance = AllocationManagementAction.getInstance();
        this._dataInstance = AllocationManagementData.getInstance();
        final List<EObject> contextualMenuSelections = WizardActionHelper.converToEObjectList(this.getSelectedElements());
        if (this._dataInstance.isValidSelection(contextualMenuSelections)) {
            final ArrayList availableElements = new ArrayList(0);
            AbstractReadOnlyCommand collectElementsCommand = new AbstractReadOnlyCommand(){

                public void run() {
                    if (AllocationManagementWizardAction.this._dataInstance.isValidSelection(contextualMenuSelections)) {
                        availableElements.addAll(AllocationManagementWizardAction.this._dataInstance.getCorrespondingData(contextualMenuSelections));
                    }
                }
            };
            this.getExecutionManager().execute((ICommand)collectElementsCommand);
            if (!this._dataInstance.isSourceDataVoid()) {
                SelectElementsDialog dialog = new SelectElementsDialog(this.getActiveShell(), Messages.AllocationManagementWizardAction_Title, this._dataInstance.getDataMessage(), availableElements);
                if (dialog.open() == 0) {
                    final ArrayList<EObject> wizardSelections = new ArrayList<EObject>();
                    List result = dialog.getResult();
                    for (EObject object : result) {
                        wizardSelections.add(object);
                    }
                    AbstractReadWriteCommand performedChangesCommand = new AbstractReadWriteCommand(){

                        public String getName() {
                            return Messages.AllocationManagementWizardAction_Command_Label;
                        }

                        public void run() {
                            AllocationManagementWizardAction.this.handleChanges(contextualMenuSelections, wizardSelections);
                        }
                    };
                    this.getExecutionManager().execute((ICommand)performedChangesCommand);
                }
            } else {
                WizardActionHelper.createMessageBox(this.getActiveShell(), Messages.AllocationManagementWizardAction_Information_Message, 2);
            }
        } else {
            WizardActionHelper.createMessageBox(this.getActiveShell(), Messages.AllocationManagementWizardAction_Warning_Message, 2);
        }
    }

    void handleChanges(List<EObject> selectedCapellaElement, List<EObject> selectedElements) {
        if (selectedElements.isEmpty()) {
            return;
        }
        if (this._dataInstance.getAllocationType() == AllocationManagementData.AllocationSelectionType.FUNCTION_ALLOCATION) {
            this._actionInstance.allocatingFunctionsToComponent(selectedCapellaElement, selectedElements.get(0));
        } else if (this._dataInstance.getAllocationType() == AllocationManagementData.AllocationSelectionType.EXCHANGE_ITEM_ALLOCATION) {
            this._actionInstance.allocatingExchangeItemsToInterfaces(selectedCapellaElement, selectedElements);
        } else if (this._dataInstance.getAllocationType() == AllocationManagementData.AllocationSelectionType.FUNCTIONAL_EXCHANGE_ALLOCATION) {
            this._actionInstance.allocatingFEsToComponentExchanges(selectedCapellaElement, selectedElements.get(0));
        } else if (this._dataInstance.getAllocationType() == AllocationManagementData.AllocationSelectionType.COMPONENT_EXCHANGE_ALLOCATION) {
            this._actionInstance.allocatingCEsToPhysicalLinks(selectedCapellaElement, selectedElements.get(0));
        } else if (this._dataInstance.getAllocationType() == AllocationManagementData.AllocationSelectionType.PHYSICAL_PART_DEPLOYMENT) {
            this._actionInstance.allocatingPCPartsToPCPart(selectedCapellaElement, selectedElements.get(0));
        }
    }
}

