/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.business.queries.capellacore.BusinessQueriesProvider;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalLinkCategory;
import org.polarsys.capella.core.platform.sirius.ui.actions.Messages;
import org.polarsys.capella.core.platform.sirius.ui.actions.UpdateCategoriesController;

public class UpdatePLCategoriesController
extends UpdateCategoriesController {
    @Override
    public void updateCategories(List<EObject> selectedElements, List<EObject> categoriesToAdd, List<EObject> categoriesToRemove) {
        for (EObject e : selectedElements) {
            if (!(e instanceof PhysicalLink)) continue;
            for (EObject removed : categoriesToRemove) {
                ((PhysicalLinkCategory)removed).getLinks().remove((Object)e);
            }
            for (EObject added : categoriesToAdd) {
                ((PhysicalLinkCategory)added).getLinks().add((Object)((PhysicalLink)e));
            }
        }
        this.logResults(Messages.UpdatePLCategories_add_msg, categoriesToAdd);
        this.logResults(Messages.UpdatePLCategories_remove_msg, categoriesToRemove);
    }

    @Override
    public List<EObject> getAvailableCategories(List<EObject> element) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject e : element) {
            IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(e.eClass(), (EStructuralFeature)CsPackage.Literals.PHYSICAL_LINK__CATEGORIES);
            if (query == null) continue;
            result.addAll(query.getAvailableElements(e));
        }
        return result;
    }

    @Override
    public List<EObject> getCommonCategories(List<EObject> selection) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (selection.isEmpty()) {
            return result;
        }
        EObject first = selection.get(0);
        if (first instanceof PhysicalLink) {
            result.addAll((Collection<EObject>)((PhysicalLink)first).getCategories());
        }
        for (EObject eObject : selection) {
            if (!(eObject instanceof PhysicalLink)) continue;
            result.retainAll((Collection<?>)((PhysicalLink)eObject).getCategories());
        }
        return result;
    }
}

