/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.commands;

import java.text.MessageFormat;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.AbstractTypedElement;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.information.AggregationKind;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.datavalue.DatavalueFactory;
import org.polarsys.capella.core.data.information.datavalue.LiteralNumericValue;
import org.polarsys.capella.core.data.information.datavalue.NumericValue;

public class ConvertPrimitiveCommand
extends AbstractReadWriteCommand {
    private ModelElement _modelElement;
    private static final Logger _logger = ReportManagerRegistry.getInstance().subscribe("Default");

    public ConvertPrimitiveCommand(ModelElement modelElement) {
        this._modelElement = modelElement;
    }

    public void run() {
        if (this._modelElement instanceof Class) {
            Class myClass = (Class)this._modelElement;
            DataPkg myClassPkg = null;
            if (myClass.eContainer() instanceof DataPkg) {
                myClassPkg = (DataPkg)myClass.eContainer();
            } else {
                _logger.error((Object)new EmbeddedMessage(MessageFormat.format("myClassPkg is null", myClass.getId()), "Model Management", (Object)myClass));
            }
            myClass.setIsPrimitive(false);
            for (AbstractTypedElement currentAbstractTypedElement : myClass.getAbstractTypedElements()) {
                if (currentAbstractTypedElement instanceof Property && myClassPkg != null) {
                    Property currentProperty = (Property)currentAbstractTypedElement;
                    currentProperty.setAggregationKind(AggregationKind.COMPOSITION);
                    Association assoc = InformationFactory.eINSTANCE.createAssociation(currentProperty.getName());
                    myClassPkg.getOwnedAssociations().add((Object)assoc);
                    assoc.setDescription(currentProperty.getDescription());
                    assoc.setSummary(currentProperty.getSummary());
                    assoc.getNavigableMembers().add((Object)currentProperty);
                    Property secondProperty = InformationFactory.eINSTANCE.createProperty();
                    EObject currentPropertyContainer = currentProperty.eContainer();
                    if (currentPropertyContainer instanceof Class) {
                        Class srcClass = (Class)currentPropertyContainer;
                        secondProperty.setAbstractType((AbstractType)srcClass);
                        assoc.getOwnedMembers().add((Object)secondProperty);
                        secondProperty.setName(srcClass.getName().substring(0, 1).toLowerCase() + srcClass.getName().substring(1));
                    } else {
                        _logger.error((Object)new EmbeddedMessage(MessageFormat.format("Container of " + currentProperty.getFullLabel() + " is not a Class !", currentProperty.getId()), "Model Management", (Object)currentProperty));
                    }
                    secondProperty.setAggregationKind(AggregationKind.ASSOCIATION);
                    LiteralNumericValue minCard = DatavalueFactory.eINSTANCE.createLiteralNumericValue();
                    LiteralNumericValue maxCard = DatavalueFactory.eINSTANCE.createLiteralNumericValue();
                    minCard.setValue("1");
                    maxCard.setValue("1");
                    secondProperty.setOwnedMinCard((NumericValue)minCard);
                    secondProperty.setOwnedMaxCard((NumericValue)maxCard);
                    continue;
                }
                _logger.error((Object)new EmbeddedMessage(MessageFormat.format("Typed Element is not a property", currentAbstractTypedElement.getId()), "Model Management", (Object)currentAbstractTypedElement));
            }
        } else {
            _logger.error((Object)new EmbeddedMessage(MessageFormat.format("Selected Element is not correct : " + this._modelElement.getFullLabel(), this._modelElement.getId()), "Model Management", (Object)this._modelElement));
        }
    }
}

